/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.rest;

import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.List;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.rest.RestService;
import openwfe.org.rest.RmiBridgedRestSession;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class RestControlSession
extends RmiBridgedRestSession {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$rest$RestControlSession == null ? (class$openwfe$org$engine$control$rest$RestControlSession = RestControlSession.class$("openwfe.org.engine.control.rest.RestControlSession")) : class$openwfe$org$engine$control$rest$RestControlSession).getName());
    private ControlSession session = null;
    private XmlWorkItemCoder coder = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$rest$RestControlSession;

    public void init(RestService service, Long sessionId, String username, String password) throws ServiceException {
        super.init(service, sessionId, username, password);
        WorkItemCoderLoader loader = Definitions.getWorkItemCoderLoader(this.getService().getContext());
        this.coder = (XmlWorkItemCoder)loader.getXmlCoder();
        log.info((Object)"WorkItemCoder successfully located");
    }

    protected boolean authentify(String username, String password) throws ServiceException {
        try {
            this.session = (ControlSession)this.getWorkSessionServer().login(username, password);
        }
        catch (Exception e) {
            throw new ServiceException("login failed", (Throwable)e);
        }
        return true;
    }

    protected Element encode(FlowExpression fe) {
        Element eExpression = new Element("expression");
        if (fe.getApplyTime() != null) {
            eExpression.setAttribute("apply-time", fe.getApplyTime());
        }
        if (fe.getState() != null) {
            eExpression.setAttribute("state", fe.getState().getName());
            eExpression.setAttribute("state-since", Time.toIsoDate((long)fe.getState().getSince()));
        }
        eExpression.addContent((Content)this.coder.encode(fe.getId()));
        return eExpression;
    }

    protected FlowExpressionId parseFei(SelectionKey key, String[] headers) throws Exception {
        return this.coder.decodeFlowExpressionId(RestControlSession.parseBody((SelectionKey)key, (String[])headers));
    }

    public void do_listexpressions(SelectionKey key, String[] headers) throws Exception {
        List expressions = this.session.listExpressions();
        Element eExpressions = new Element("expressions");
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            eExpressions.addContent((Content)this.encode(fe));
        }
        this.reply(key, eExpressions);
    }

    public void do_cancelexpression(SelectionKey key, String[] headers) throws Exception {
        this.session.cancelExpression(this.parseFei(key, headers));
        this.reply(key, new Element("ok"));
    }

    public void do_freezeexpression(SelectionKey key, String[] headers) throws Exception {
        this.session.freezeExpression(this.parseFei(key, headers));
        this.reply(key, new Element("ok"));
    }

    public void do_unfreezeexpression(SelectionKey key, String[] headers) throws Exception {
        this.session.unfreezeExpression(this.parseFei(key, headers));
        this.reply(key, new Element("ok"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

