/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.control.ControlException;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.actions.CancelExpressionAction;
import openwfe.org.engine.control.actions.FreezeExpressionAction;
import openwfe.org.engine.control.actions.FreezeFlowAction;
import openwfe.org.engine.control.actions.ListAction;
import openwfe.org.engine.control.actions.UnfreezeExpressionAction;
import openwfe.org.engine.expressions.FlowExpressionId;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ControlSessionImpl
extends UnicastRemoteObject
implements ControlSession,
Service {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$rmi$ControlSessionImpl == null ? (class$openwfe$org$engine$control$rmi$ControlSessionImpl = ControlSessionImpl.class$("openwfe.org.engine.control.rmi.ControlSessionImpl")) : class$openwfe$org$engine$control$rmi$ControlSessionImpl).getName());
    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private Map serviceParams = null;
    private Subject subject = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$rmi$ControlSessionImpl;

    public void init(String serviceName, ApplicationContext applicationContext, Map serviceParams) throws ServiceException {
        this.serviceName = serviceName;
        this.applicationContext = applicationContext;
        this.serviceParams = serviceParams;
        this.subject = (Subject)serviceParams.get("__subject__");
        if (this.subject == null) {
            log.warn((Object)"init() no subject passed.");
        }
    }

    public Element getStatus() {
        return null;
    }

    public Map getParams() {
        return this.serviceParams;
    }

    public ApplicationContext getContext() {
        return this.applicationContext;
    }

    public String getName() {
        return this.serviceName;
    }

    public List listExpressions() throws RemoteException {
        try {
            Object result = Subject.doAs(this.subject, new ListAction(this.applicationContext, this.subject));
            return (List)result;
        }
        catch (PrivilegedActionException pae) {
            log.warn((Object)"failure", (Throwable)pae.getException());
            return null;
        }
    }

    public void unfreezeExpression(FlowExpressionId freezableExpressionId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new UnfreezeExpressionAction(this.applicationContext, this.subject, freezableExpressionId));
        }
        catch (PrivilegedActionException pae) {
            log.warn((Object)"failure", (Throwable)pae.getException());
        }
    }

    public void cancelExpression(FlowExpressionId fei) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new CancelExpressionAction(this.applicationContext, this.subject, fei));
        }
        catch (PrivilegedActionException pae) {
            log.warn((Object)"failure", (Throwable)pae.getException());
        }
    }

    public void freezeFlow(String workflowInstanceId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new FreezeFlowAction(this.applicationContext, this.subject, workflowInstanceId));
        }
        catch (PrivilegedActionException pae) {
            log.warn((Object)"failure", (Throwable)pae.getException());
        }
    }

    public void freezeExpression(FlowExpressionId freezableExpressionId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new FreezeExpressionAction(this.applicationContext, this.subject, freezableExpressionId));
        }
        catch (PrivilegedActionException pae) {
            log.warn((Object)"failure", (Throwable)pae.getException());
        }
    }

    public void release() throws RemoteException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

