/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.shell;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.Naming;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.rmi.session.WorkSessionServer;
import openwfe.org.shell.CmdHandler;

public class ControlShell {
    public static final String BANNER = "\n" + (class$openwfe$org$engine$control$shell$ControlShell == null ? (class$openwfe$org$engine$control$shell$ControlShell = ControlShell.class$("openwfe.org.engine.control.shell.ControlShell")) : class$openwfe$org$engine$control$shell$ControlShell).getName() + "\n$Revision: 1882 $ John Mettraux, Jay Lawrence\n";
    private String url;
    private ControlSession session;
    private String prompt;
    private String language = null;
    private BufferedReader reader;
    private List lastExpressionList = null;
    static final Comparator expressionComparator = new Comparator(){

        public int compare(Object fe1, Object fe2) {
            FlowExpressionId feId1 = ((FlowExpression)fe1).getId();
            FlowExpressionId feId2 = ((FlowExpression)fe2).getId();
            return feId1.getWorkflowInstanceId().compareTo(feId2.getWorkflowInstanceId());
        }
    };
    static /* synthetic */ Class class$openwfe$org$engine$control$shell$ControlShell;

    public ControlShell(String url, ControlSession session, BufferedReader reader) {
        this.url = url;
        this.session = session;
        this.prompt = url + "> ";
        this.reader = reader;
    }

    private String toString(FlowExpression fe) {
        boolean isUnapplied = fe.getApplyTime() == null;
        StringBuffer sb = new StringBuffer();
        if (fe.getState() != null) {
            sb.append(fe.getState().getIdentifier());
        } else {
            sb.append("-");
        }
        if (isUnapplied) {
            sb.append("u");
        } else {
            sb.append("-");
        }
        sb.append("  ");
        sb.append(fe.getId().getWorkflowInstanceId());
        sb.append("  ");
        sb.append(fe.getId().getWorkflowDefinitionName());
        sb.append(" ");
        sb.append(fe.getId().getWorkflowDefinitionRevision());
        sb.append("  ");
        sb.append(fe.getId().getExpressionName());
        sb.append(" ");
        sb.append(fe.getId().getExpressionId());
        return sb.toString();
    }

    private void displayExpressionList(String title, List list) {
        System.out.println(title);
        Collections.sort(list, expressionComparator);
        this.lastExpressionList = list;
        if (list == null) {
            System.out.println(" X   no results");
            return;
        }
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            System.out.println("    - " + i + "  " + this.toString(fe));
            ++i;
        }
    }

    private FlowExpressionId getExpression(String sExpressionId) {
        if (this.lastExpressionList == null) {
            throw new IllegalArgumentException("No exceptions were 'list'ed before");
        }
        int index = -1;
        try {
            index = Integer.parseInt(sExpressionId);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("'" + sExpressionId + "' is not a number");
        }
        if (index < 0 || index - 1 > this.lastExpressionList.size()) {
            throw new IllegalArgumentException("No expression at index " + index);
        }
        return ((FlowExpression)this.lastExpressionList.get(index)).getId();
    }

    public void help_list() {
        System.out.println("list");
        System.out.println("  lists both frozen and unapplied expressions");
    }

    public Boolean do_list(String[] args) {
        try {
            this.displayExpressionList("expressions :", this.session.listExpressions());
            return Boolean.FALSE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public void help_unfreeze() {
        System.out.println("unfreezex <expression_id>");
        System.out.println("  defreeze an expression, the engine will immediately try to apply it");
    }

    public Boolean do_unfreeze(String[] args) {
        if (args.length < 1) {
            this.help_unfreeze();
            return Boolean.FALSE;
        }
        try {
            this.session.unfreezeExpression(this.getExpression(args[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public void help_freeze() {
        System.out.println("freezex <expression_id>");
        System.out.println("  freezes an expression, the engine will immediately try to apply it");
    }

    public Boolean do_freeze(String[] args) {
        if (args.length < 1) {
            this.help_freeze();
            return Boolean.FALSE;
        }
        try {
            this.session.freezeExpression(this.getExpression(args[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public void help_cancel() {
        System.out.println("cancel <expression_id>");
        System.out.println("  cancels an expression (and all its children)");
        System.out.println("  and replies to its parent expression.");
    }

    public Boolean do_cancel(String[] args) {
        if (args.length < 1) {
            this.help_cancel();
            return Boolean.FALSE;
        }
        try {
            this.session.cancelExpression(this.getExpression(args[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public Boolean do_quit(String[] args) {
        return CmdHandler.DO_EXIT;
    }

    public Boolean do_exit(String[] args) {
        return CmdHandler.DO_EXIT;
    }

    public void run() {
        CmdHandler parser = new CmdHandler((Object)this);
        parser.commandLoop(this.prompt, this.reader);
        System.out.println("Bye.");
        System.exit(0);
    }

    public static void main(String[] args) {
        String arg;
        String DEFAULT_URL = "rmi://localhost:7089/controlSessionServer";
        System.out.println(BANNER);
        if (args.length > 0 && ((arg = args[0].trim().toLowerCase()).equals("-help") || arg.equals("--help") || arg.equals("-h") || arg.equals("-?"))) {
            System.out.println("OpenWFE engine control client");
            System.out.println();
            System.out.println("Usage: " + (class$openwfe$org$engine$control$shell$ControlShell == null ? (class$openwfe$org$engine$control$shell$ControlShell = ControlShell.class$("openwfe.org.engine.control.shell.ControlShell")) : class$openwfe$org$engine$control$shell$ControlShell).getName() + " [<session server URL> [<username> [<password>]]");
            System.out.println();
            System.out.println("Default URL is rmi://localhost:7089/controlSessionServer");
            System.exit(0);
        }
        try {
            String password;
            String username;
            String url = args.length > 0 ? args[0] : "rmi://localhost:7089/controlSessionServer";
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            if (args.length > 1) {
                username = args[1];
            } else {
                System.out.print("username> ");
                username = reader.readLine();
            }
            if (args.length > 2) {
                password = args[2];
            } else {
                System.out.print("password> ");
                password = reader.readLine();
            }
            WorkSessionServer sessionServer = (WorkSessionServer)Naming.lookup(url);
            ControlSession session = (ControlSession)sessionServer.login(username, password);
            new ControlShell(url, session, reader).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

