/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.dispatch;

import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.FatalDispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import org.apache.log4j.Logger;

public abstract class AbstractWorkItemDispatcher
extends AbstractService
implements WorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher == null ? (class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher = AbstractWorkItemDispatcher.class$("openwfe.org.engine.dispatch.AbstractWorkItemDispatcher")) : class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher).getName());
    public static final String WORKITEM_CODER = "workItemCoder";
    private String workItemCoderName = null;
    static /* synthetic */ Class class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.workItemCoderName = MapUtils.getAsString((Map)this.getParams(), (String)WORKITEM_CODER);
        WorkItemCoderLoader loader = Definitions.getWorkItemCoderLoader(this.getContext());
        WorkItemCoder coder = loader.getCoder(this.workItemCoderName);
        if (coder == null) {
            coder = loader.getDefaultCoder();
            log.info((Object)"using default coder");
        }
        this.workItemCoderName = coder.getName();
        log.info((Object)("Dispatcher '" + this.getName() + "' using coder '" + this.workItemCoderName + "'"));
    }

    public String getWorkItemCoderName() {
        return this.workItemCoderName;
    }

    protected WorkItemCoder instantiateEncoder() throws DispatchingException {
        WorkItemCoderLoader coderLoader = Definitions.getWorkItemCoderLoader(this.getContext());
        WorkItemCoder coder = coderLoader.getDefaultCoder();
        if (this.workItemCoderName != null) {
            coder = coderLoader.getCoder(this.workItemCoderName);
        }
        return coder;
    }

    protected Object handleReply(ListenerReply reply) throws DispatchingException {
        if (reply == null) {
            throw new DispatchingException("No reply from listener");
        }
        if (reply instanceof FatalReply) {
            throw new FatalDispatchingException((FatalReply)reply);
        }
        if (reply instanceof OkReply) {
            log.debug((Object)"Listener replied 'ok'");
            return ((OkReply)reply).getConsumerResult();
        }
        WarningReply warn = (WarningReply)reply;
        StringBuffer sb = new StringBuffer();
        sb.append("listener warned :\n");
        sb.append(warn.getMessage());
        sb.append('\n');
        sb.append(warn.getExceptionMessage());
        sb.append('\n');
        sb.append(warn.getExceptionStackTrace());
        log.warn((Object)sb.toString());
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

