/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class ChildrenTracker {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ChildrenTracker == null ? (class$openwfe$org$engine$expressions$ChildrenTracker = ChildrenTracker.class$("openwfe.org.engine.expressions.ChildrenTracker")) : class$openwfe$org$engine$expressions$ChildrenTracker).getName());
    private String[] childrenToMap = null;
    private String remainingContent = null;
    private InFlowWorkItem workitem = null;
    private Element xmlContent = null;
    private int position = -1;
    private Map results = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ChildrenTracker;

    public void init(String initialContent, String[] childrenToMap, InFlowWorkItem wi) throws ApplyException {
        this.remainingContent = initialContent;
        this.childrenToMap = childrenToMap;
        this.workitem = (InFlowWorkItem)wi.clone();
        try {
            this.initializeXmlContent(true);
        }
        catch (Exception e) {
            log.warn((Object)("failed to parse children out of \n" + this.remainingContent), (Throwable)e);
            throw new ApplyException("failed to parse children", e);
        }
        this.position = 0;
        this.results = new HashMap();
    }

    protected void initializeXmlContent(boolean force) throws Exception {
        if (force || this.xmlContent == null) {
            this.xmlContent = XmlUtils.extractXmlElement((String)this.remainingContent);
            this.xmlContent = ChildrenTracker.cleanElement(this.xmlContent);
            this.remainingContent = XmlUtils.xmlToString((Content)this.xmlContent);
        }
    }

    public String[] getChildrenToMap() {
        return this.childrenToMap;
    }

    public void setChildrenToMap(String[] s) {
        this.childrenToMap = s;
    }

    public String getRemainingContent() {
        return this.remainingContent;
    }

    public void setRemainingContent(String s) {
        this.remainingContent = s;
    }

    public InFlowWorkItem getWorkitem() {
        return this.workitem;
    }

    public void setWorkitem(InFlowWorkItem wi) {
        this.workitem = wi;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int i) {
        this.position = i;
    }

    public Map getResults() {
        return this.results;
    }

    public void setResults(Map m) {
        this.results = m;
    }

    public boolean hasNext() {
        log.debug((Object)("hasNext() ? " + (this.position < this.childrenToMap.length)));
        return this.position < this.childrenToMap.length;
    }

    public void applyNext(FlowExpression owner) throws ReplyException {
        InFlowWorkItem wi = (InFlowWorkItem)this.workitem.clone();
        Content c = this.fetchFirstChild();
        if (c == null) {
            log.debug((Object)"applyNext() no child");
            ValueUtils.setResult(wi, "");
            owner.reply(wi);
            return;
        }
        try {
            Launcher launcher = Definitions.getLauncher(owner.context());
            RawExpression next = launcher.eval(owner, c, wi);
            log.debug((Object)("applyNext() next is  " + next.getId()));
            owner.storeItself();
            next.apply(wi);
        }
        catch (Throwable t) {
            throw new ReplyException("failed to apply next [nested] child", t);
        }
    }

    public void reply(InFlowWorkItem wi) {
        log.debug((Object)("reply() " + this + " this.position is " + this.position));
        String childName = this.childrenToMap[this.position];
        Attribute childValue = ValueUtils.getResult(wi);
        this.results.put(childName, childValue);
        ++this.position;
    }

    private Content fetchFirstChild() throws ReplyException {
        try {
            this.initializeXmlContent(false);
        }
        catch (Exception e) {
            throw new ReplyException("failed to prepare xml content", e);
        }
        if (this.xmlContent.getContent().size() < 1) {
            return null;
        }
        Content c = this.xmlContent.removeContent(0);
        this.remainingContent = XmlUtils.toString((Content)this.xmlContent);
        return c;
    }

    private static Element cleanElement(Element elt) {
        Element result = new Element(elt.getName());
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Content c = (Content)it.next();
            if (c instanceof Text && ((Text)c).getTextTrim().length() < 1) continue;
            result.addContent((Content)c.clone());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

