/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class SleepExpression
extends ZeroChildExpression
implements Schedulable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$SleepExpression == null ? (class$openwfe$org$engine$expressions$SleepExpression = SleepExpression.class$("openwfe.org.engine.expressions.SleepExpression")) : class$openwfe$org$engine$expressions$SleepExpression).getName());
    public static final String FOR = "for";
    public static final String UNTIL = "until";
    private InFlowWorkItem sleepingWorkitem = null;
    private long awakeningTime = -1L;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$SleepExpression;

    public InFlowWorkItem getSleepingWorkitem() {
        return this.sleepingWorkitem;
    }

    public long getAwakeningTime() {
        return this.awakeningTime;
    }

    public void setSleepingWorkitem(InFlowWorkItem wi) {
        this.sleepingWorkitem = wi;
    }

    public void setAwakeningTime(long l) {
        this.awakeningTime = l;
    }

    public void trigger(Object[] params) {
        if (this.sleepingWorkitem == null) {
            return;
        }
        try {
            this.applyToParent(this.sleepingWorkitem);
        }
        catch (ApplyException e) {
            log.warn((Object)"trigger() couldn't reply to parent expression !!!", (Throwable)((Object)e));
        }
    }

    public Long reschedule(Scheduler s) {
        this.getExpressionPool().scheduleAt(this.awakeningTime, this.getId());
        return new Long(-1L);
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        String sFor = this.lookupAttribute(FOR, wi);
        String sUntil = this.lookupAttribute(UNTIL, wi);
        log.debug((Object)("apply() sFor   >" + sFor + "<"));
        log.debug((Object)("apply() sUntil >" + sUntil + "<"));
        if (sFor != null) {
            long duration = Time.parseTimeString((String)sFor);
            this.awakeningTime = System.currentTimeMillis() + duration;
        } else {
            if (sUntil == null) {
                this.throwSleepException(wi, "no 'for' or 'until' found, no sleep.");
                return;
            }
            try {
                this.awakeningTime = Time.parseDate((String)sUntil).getTime();
            }
            catch (Throwable t) {
                this.throwSleepException(wi, "Couldn't parse '" + sUntil + "' : " + t);
                return;
            }
        }
        this.sleepingWorkitem = wi;
        this.storeItself();
        log.debug((Object)("apply() now is " + Time.toIsoDate()));
        log.debug((Object)("apply() entered sleep 'til " + Time.toIsoDate((long)this.awakeningTime)));
        this.reschedule(null);
    }

    protected void throwSleepException(InFlowWorkItem wi, String message) throws ApplyException {
        wi.addHistoryItem(this.getId(), this.getClass().getName(), message);
        this.historyLog(wi, "-err", null, message);
        log.debug((Object)message);
        this.applyToParent(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

