/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import org.apache.log4j.Logger;

public class WhenExpression
extends CleanCompositeFlowExpression
implements ExpressionWithTimeOut,
Schedulable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$WhenExpression == null ? (class$openwfe$org$engine$expressions$WhenExpression = WhenExpression.class$("openwfe.org.engine.expressions.WhenExpression")) : class$openwfe$org$engine$expressions$WhenExpression).getName());
    private InFlowWorkItem workitem = null;
    private boolean conditionTreated = false;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$WhenExpression;

    public InFlowWorkItem getWorkitem() {
        return this.workitem;
    }

    public boolean isConditionTreated() {
        return this.conditionTreated;
    }

    public void setWorkitem(InFlowWorkItem wi) {
        if (wi == null) {
            return;
        }
        this.workitem = (InFlowWorkItem)wi.clone();
    }

    public void setConditionTreated(boolean b) {
        this.conditionTreated = b;
    }

    public void trigger(Object[] params) {
        log.debug((Object)"trigger()");
        FlowExpressionId templateId = (FlowExpressionId)this.getChildren().get(0);
        if (this.workitem == null) {
            log.debug((Object)"trigger() workitem is null. 'when' Skipped.");
            return;
        }
        if (this.isConditionTreated()) {
            log.debug((Object)"trigger() condition already treated. Returning");
            return;
        }
        this.tag(this.workitem);
        log.debug((Object)"trigger() workitem got tagged");
        try {
            this.getLauncher().launchSub(this.workitem, this.getId(), templateId, null, true);
        }
        catch (LaunchException e) {
            log.warn((Object)"trigger() failed to launch condition checking logic !!!", (Throwable)((Object)e));
        }
    }

    public Long reschedule(Scheduler s) {
        this.getExpressionPool().schedule(this.getId());
        return new Long(-1L);
    }

    protected String getNameInHistory() {
        return this.getClass().getName() + " $Revision: 2436 $";
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        log.debug((Object)"apply()");
        this.setWorkitem(wi);
        this.storeItself();
        this.trigger(null);
    }

    public void replyToParent(InFlowWorkItem wi) throws ReplyException {
        if (this.getChildren() != null && this.getChildren().size() > 0) {
            log.debug((Object)("replyToParent() removing template " + this.getChildren().get(0)));
            this.getExpressionPool().removeExpression((FlowExpressionId)this.getChildren().get(0));
        }
        super.replyToParent(wi);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        log.debug((Object)"reply()");
        if (this.isConditionTreated()) {
            log.debug((Object)"reply() condition is treated - replying to parent");
            this.replyToParent(wi);
            return;
        }
        if (ValueUtils.lookupBooleanResult(wi)) {
            this.workitem.addHistoryItem(this.getNameInHistory(), "triggered");
            this.historyLog(wi, "-inf", null, this.getNameInHistory());
            if (this.getChildren().size() < 2) {
                log.info((Object)"reply() condition realized but no child to apply");
                this.replyToParent(wi);
                return;
            }
            log.debug((Object)"reply() setting conditionTreated to true");
            this.setConditionTreated(true);
            try {
                this.storeItself();
                this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(1), this.workitem);
            }
            catch (ApplyException ae) {
                throw new ReplyException("reply() failure", (Throwable)((Object)ae));
            }
        } else {
            log.info((Object)"reply() conditional clause returned with 'false'");
            this.reschedule(null);
        }
    }

    public boolean isTimeOutActivated() {
        return true;
    }

    public Long determineTimeOut() {
        Long timeOut = TimeoutUtils.determineTimeout(this, this.workitem);
        if (timeOut == null) {
            timeOut = this.getExpressionPool().getExpressionTimeOut();
        }
        if (timeOut == null) {
            timeOut = new Long(-1L);
        }
        return timeOut;
    }

    public void timeOutReply() throws ReplyException {
        this.getWorkitem().addHistoryItem(this.getNameInHistory(), "timed out");
        this.historyLog(null, "+TOU", null, this.getNameInHistory());
        log.debug((Object)"timeOutReply() resuming flow");
        this.reply(this.getWorkitem());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

