/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.raw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.DefinitionExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.SubProcessRefExpression;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class XmlRawExpression
extends RawExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$raw$XmlRawExpression == null ? (class$openwfe$org$engine$expressions$raw$XmlRawExpression = XmlRawExpression.class$("openwfe.org.engine.expressions.raw.XmlRawExpression")) : class$openwfe$org$engine$expressions$raw$XmlRawExpression).getName());
    private static final String A_NAME = "name";
    private static final String A_REVISION = "revision";
    private static final String E_DESCRIPTION = "description";
    private static final String E_INCLUDE = "include";
    private static final String A_URL = "url";
    private Element xmlBranch = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$raw$XmlRawExpression;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$DefinitionExpression;

    public void init(ApplicationContext context, FlowExpressionId environmentId, FlowExpressionId parentId, int expressionId, Object raw) throws BuildException {
        this.setApplicationContext(context);
        if (parentId.getExpressionName() != null) {
            this.setParent(parentId);
        }
        this.xmlBranch = (Element)raw;
        this.xmlBranch.detach();
        this.setId(this.determineId(parentId, this.xmlBranch.getName(), expressionId));
        this.setEnvironmentId(environmentId);
        log.debug((Object)("init() 0 set id to     " + this.getId()));
        log.debug((Object)("init() 0 set parent to " + this.getParent()));
        log.debug((Object)("init() 0 set env id to " + this.getEnvironmentId()));
    }

    public void init(ApplicationContext context, FlowExpressionId environmentId, FlowExpressionId parentId, FlowExpressionId id, Object raw) throws BuildException {
        this.setApplicationContext(context);
        this.setEnvironmentId(environmentId);
        this.setParent(parentId);
        this.setId(id);
        this.xmlBranch = (Element)raw;
        this.xmlBranch.detach();
        log.debug((Object)("init() 1 set id to     " + this.getId()));
        log.debug((Object)("init() 1 set parent to " + this.getParent()));
        log.debug((Object)("init() 1 set env id to " + this.getEnvironmentId()));
    }

    public boolean isDefinition() {
        Class c = this.getExpressionClass();
        if (c == null) {
            log.warn((Object)("isDefinition() did not found expression named '" + this.xmlBranch.getName()));
            return false;
        }
        return (class$openwfe$org$engine$expressions$DefinitionExpression == null ? (class$openwfe$org$engine$expressions$DefinitionExpression = XmlRawExpression.class$("openwfe.org.engine.expressions.DefinitionExpression")) : class$openwfe$org$engine$expressions$DefinitionExpression).isAssignableFrom(c);
    }

    public boolean isWorkflowDefinition() {
        return this.getDefinitionName() != null && this.xmlBranch.getAttributeValue(A_REVISION) != null;
    }

    public String getDefinitionName() {
        return this.xmlBranch.getAttributeValue(A_NAME);
    }

    public Class getExpressionClass() {
        String expressionName = this.xmlBranch.getName();
        return this.getExpressionMap().getClass(expressionName);
    }

    public Element getXmlBranch() {
        return this.xmlBranch;
    }

    public void setXmlBranch(Element e) {
        this.xmlBranch = e;
    }

    public Object clone() {
        XmlRawExpression clone = (XmlRawExpression)super.clone();
        clone.setXmlBranch((Element)this.getXmlBranch().clone());
        return clone;
    }

    public FlowExpression resolveExpression(InFlowWorkItem currentWi) throws BuildException {
        return this.resolveExpression(currentWi, null);
    }

    public FlowExpression resolveExpression(ProcessDefinition def) throws BuildException {
        return this.resolveExpression(null, def);
    }

    private FlowExpression resolveExpression(InFlowWorkItem currentWi, ProcessDefinition def) throws BuildException {
        this.setProcessDefinition(def);
        String expressionName = this.xmlBranch.getName();
        log.debug((Object)("resolveExpression() expressionName >" + expressionName + "<"));
        Object oValue = null;
        if (def == null) {
            oValue = this.lookupVariable(expressionName);
        }
        Class expressionClass = this.getExpressionMap().getClass(expressionName);
        FlowExpression fe = null;
        log.debug((Object)("resolveExpression() this.parent is " + this.getParent()));
        log.debug((Object)("resolveExpression() oValue is " + oValue));
        if (oValue != null && oValue instanceof FlowExpressionId || oValue != null && oValue instanceof RawExpression || def != null && expressionClass == null) {
            log.debug((Object)"resolveExpression() 'subprocess' expression");
            HashMap<String, String> feParams = new HashMap<String, String>(1);
            feParams.put("ref", expressionName);
            feParams.putAll(XmlUtils.fetchAttributes((Element)this.xmlBranch));
            fe = new SubProcessRefExpression();
            Map atParams = this.getLauncher().fetchAttributes(fe, this.xmlBranch);
            feParams.putAll(atParams);
            this.setGeneratedExpression(fe);
            fe.init(this.context(), this.getEnvironmentId(), this.getParent(), this.getId(), this, feParams, currentWi);
        } else {
            if (oValue != null && oValue instanceof Class) {
                log.debug((Object)"resolveExpression() built-in expression");
                expressionClass = (Class)oValue;
                try {
                    fe = (FlowExpression)expressionClass.newInstance();
                }
                catch (Exception e) {
                    throw new BuildException("Failed to prepare built-in expression '" + expressionName + "'", e);
                }
            } else {
                log.debug((Object)"resolveExpression() built-in expression (not found through var lookup)");
                fe = this.getExpressionMap().instantiateExpression(expressionName);
            }
            this.setGeneratedExpression(fe);
            fe.init(this.context(), this.getEnvironmentId(), this.getParent(), this.getId(), this, this.xmlBranch, currentWi);
            log.debug((Object)("resolveExpression() set parent\n    for " + fe.getId() + "\n    to " + this.getParent()));
        }
        if (this.getAttributes().keySet().contains("map-children")) {
            log.debug((Object)("resolveExpression() map-children >" + this.getAttributes().get("map-children") + "<"));
            fe.getAttributes().put("map-children", this.getAttributes().get("map-children"));
        }
        log.debug((Object)("resolveExpression() init for fe " + fe.getId()));
        if (def == null) {
            try {
                this.getExpressionPool().add(fe);
            }
            catch (PoolException pe) {
                log.debug((Object)("Failed to add resolved expression to pool " + fe.getId()), (Throwable)((Object)pe));
                throw new BuildException("Failed to add resolved expression to pool " + fe.getId());
            }
        } else {
            log.debug((Object)("resolveExpression() fe class is " + fe.getClass().getName()));
            def.add(fe);
        }
        return fe;
    }

    private void pcInclude(Element elt, InFlowWorkItem currentWi, List preChildren) {
        String url = elt.getAttributeValue(A_URL);
        if (url == null) {
            return;
        }
        log.debug((Object)("pcInclude() url  is >" + url + "<"));
        this.getAttributes().put(A_URL, url);
        url = this.lookupAttribute(A_URL, currentWi);
        log.debug((Object)("pcInclude() url' is >" + url + "<"));
        try {
            Element iElt = XmlUtils.extractXml((String)url, (boolean)SimpleXmlLauncher.shouldValidate());
            this.pcFirstPass(iElt, currentWi, preChildren);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to include '" + url + "'. Skipped."), (Throwable)e);
        }
    }

    private void pcFirstPass(Element elt, InFlowWorkItem currentWi, List preChildren) {
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Element cElt;
            Content cContent = (Content)it.next();
            if (cContent instanceof Text) {
                preChildren.add(cContent);
                continue;
            }
            if (!(cContent instanceof Element) || (cElt = (Element)cContent).getName().equals(E_DESCRIPTION)) continue;
            if (cElt.getName().equals(E_INCLUDE)) {
                this.pcInclude(cElt, currentWi, preChildren);
                continue;
            }
            preChildren.add(cElt);
        }
    }

    public List prepareChildren(InFlowWorkItem currentWi) throws BuildException {
        ArrayList<Object> children = new ArrayList<Object>(this.xmlBranch.getChildren().size());
        ArrayList preChildren = new ArrayList(this.xmlBranch.getChildren().size());
        this.pcFirstPass(this.xmlBranch, currentWi, preChildren);
        int i = 0;
        Iterator it = preChildren.iterator();
        while (it.hasNext()) {
            Content content = (Content)it.next();
            content.detach();
            if (content instanceof Text) {
                children.add(((Text)content).getText());
                continue;
            }
            Element elt = (Element)content;
            XmlRawExpression child = new XmlRawExpression();
            child.init(this.context(), this.getEnvironmentId(), this.getId(), i, (Object)elt);
            ++i;
            if (this.getProcessDefinition() == null) {
                try {
                    this.getExpressionPool().add(child);
                }
                catch (PoolException pe) {
                    throw new BuildException("Failed to add child to pool " + child.getId(), (Throwable)((Object)pe));
                }
            } else {
                FlowExpression resolvedChild = child.resolveExpression(this.getProcessDefinition());
                if (resolvedChild instanceof DefinitionExpression) {
                    String name = (String)resolvedChild.getAttributes().get(A_NAME);
                    log.debug((Object)("prepareChildren() DefinitionExpression named '" + name + "'"));
                    this.getGeneratedExpression().bindVariable(name, resolvedChild);
                }
                this.getProcessDefinition().add(resolvedChild);
            }
            children.add(child.getId());
        }
        return children;
    }

    public Element dump() {
        Element elt = super.dump();
        Element eRaw = new Element("raw");
        Element eBranch = (Element)this.xmlBranch.clone();
        eBranch.detach();
        eRaw.addContent((Content)eBranch);
        elt.addContent((Content)eRaw);
        return elt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

