/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.state;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.state.AbstractExpressionState;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class FrozenState
extends AbstractExpressionState {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$state$FrozenState == null ? (class$openwfe$org$engine$expressions$state$FrozenState = FrozenState.class$("openwfe.org.engine.expressions.state.FrozenState")) : class$openwfe$org$engine$expressions$state$FrozenState).getName());
    public static final String EVT_FREEZE = "+FRZ";
    public static final String EVT_UNFREEZE = "+UFZ";
    private static final String NAME = "frozen";
    private static final char IDENTIFIER = 'f';
    private InFlowWorkItem appliedItem = null;
    private List replyQueue = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$state$FrozenState;

    public InFlowWorkItem getAppliedItem() {
        return this.appliedItem;
    }

    public List getReplyQueue() {
        return this.replyQueue;
    }

    public void setAppliedItem(InFlowWorkItem wi) {
        this.appliedItem = wi;
    }

    public void setReplyQueue(List rq) {
        this.replyQueue = rq;
    }

    public String getName() {
        return NAME;
    }

    public char getIdentifier() {
        return 'f';
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        if (this.appliedItem != null) {
            throw new ApplyException("An expression should not get applied twice.");
        }
        this.appliedItem = (InFlowWorkItem)wi.clone();
        log.debug((Object)("apply() applied item lastExpressionId : " + this.appliedItem.getLastExpressionId()));
        this.expression.storeItself();
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        log.debug((Object)"reply() freezing incoming wi");
        if (this.replyQueue == null) {
            this.replyQueue = new LinkedList();
        }
        this.replyQueue.add(wi);
        this.expression.storeItself();
    }

    public InFlowWorkItem cancel() throws ApplyException {
        this.expression.cancel();
        return this.appliedItem;
    }

    public void exitState() throws ApplyException {
        this.expression.setState(null);
        if (this.appliedItem == null && this.replyQueue == null) {
            log.debug((Object)"exitState() simple unfreeze done.");
            return;
        }
        if (this.replyQueue == null) {
            log.debug((Object)("exitState() applying (exp) " + this.expression.getId()));
            log.debug((Object)("exitState() applying (itm) " + this.appliedItem.getLastExpressionId()));
            this.expression.apply(this.appliedItem);
        } else {
            log.debug((Object)("exitState() replying to " + this.expression.getId()));
            Iterator it = this.replyQueue.iterator();
            while (it.hasNext()) {
                InFlowWorkItem wi = (InFlowWorkItem)it.next();
                try {
                    this.expression.reply(wi);
                }
                catch (ReplyException re) {
                    log.warn((Object)"exitState() failure during 'reply' defreeze", (Throwable)((Object)re));
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

