/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions.xeme;

import java.util.Iterator;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public abstract class XemeUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$xeme$XemeUtils == null ? (class$openwfe$org$engine$expressions$xeme$XemeUtils = XemeUtils.class$("openwfe.org.engine.expressions.xeme.XemeUtils")) : class$openwfe$org$engine$expressions$xeme$XemeUtils).getName());
    public static final Content NULL_RESULT = new Text("");
    static /* synthetic */ Class class$openwfe$org$engine$expressions$xeme$XemeUtils;

    public static int size(Content c) {
        if (c instanceof Text) {
            if (XemeUtils.isNotEmptyText(c)) {
                return 1;
            }
            return 0;
        }
        int result = 0;
        Element elt = (Element)c;
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Content cc = (Content)it.next();
            if (cc instanceof Element) {
                ++result;
                continue;
            }
            if (!(cc instanceof Text) || !XemeUtils.isNotEmptyText(cc)) continue;
            ++result;
        }
        return result;
    }

    public static Content nth(int index, Content c) {
        if (c instanceof Text) {
            String s = ((Text)c).getTextTrim();
            while (index < 0) {
                index = s.length() + index;
            }
            log.debug((Object)("nth() 0 index : " + index));
            if (index >= s.length()) {
                return NULL_RESULT;
            }
            return new Text("" + s.charAt(index));
        }
        int size = XemeUtils.size(c);
        while (index < 0) {
            index = size + index;
        }
        Element elt = (Element)c;
        int i = 0;
        Iterator it = elt.getContent().iterator();
        while (it.hasNext()) {
            Content cc = (Content)it.next();
            if (XemeUtils.isNotEmptyText(cc) && i == index) {
                return cc;
            }
            if (!XemeUtils.isNotEmptyText(cc)) continue;
            ++i;
        }
        return NULL_RESULT;
    }

    private static boolean isNotEmptyText(Content c) {
        if (!(c instanceof Text)) {
            return true;
        }
        return ((Text)c).getTextTrim().length() > 0;
    }

    public static Content car(Content c) {
        log.debug((Object)("car() input is of class " + c.getClass().getName()));
        Element elt = XemeUtils.toElement(c);
        if (elt.getContent().size() < 1) {
            throw new IllegalArgumentException("cannot car an empty element");
        }
        for (int i = 0; i < elt.getContent().size(); ++i) {
            Content result = (Content)elt.getContent().get(i);
            log.debug((Object)("car() result is >" + result.toString() + "<"));
            if (result instanceof Text && ((Text)result).getTextTrim().length() < 1) continue;
            log.debug((Object)("car() returning >" + XmlUtils.xmlToString((Content)result) + "<"));
            return (Content)result.clone();
        }
        return null;
    }

    public static Element cdr(Content c) {
        Element elt = XemeUtils.toElement(c);
        if (elt.getContent().size() < 1) {
            throw new IllegalArgumentException("cannot cdr an empty element");
        }
        Element result = (Element)elt.clone();
        result = XemeUtils.removeFirstChild(result);
        return result;
    }

    private static Element removeFirstChild(Element e) {
        Content c = e.removeContent(0);
        if (c == null) {
            return e;
        }
        if (c instanceof Element) {
            return e;
        }
        if (c instanceof Text && ((Text)c).getTextTrim().length() > 0) {
            return e;
        }
        return XemeUtils.removeFirstChild(e);
    }

    public static Text xar(Content c) {
        Element elt = XemeUtils.toElement(c);
        return new Text(elt.getName());
    }

    public static Element cons(Content c0, Content c1) {
        Element result = XemeUtils.toElement(c1);
        result.addContent(0, (Content)c0.clone());
        return result;
    }

    public static Element append(Content c0, Content c1) {
        Element result = XemeUtils.toElement(c0);
        Element l1 = XemeUtils.toElement(c1);
        Iterator it = l1.getContent().iterator();
        while (it.hasNext()) {
            Content c = (Content)it.next();
            c = (Content)c.clone();
            c.detach();
            result.addContent(c);
        }
        return result;
    }

    public static Element xons(Content c0, Content c1) {
        Element eResult = XemeUtils.toElement(c1);
        if (c0 instanceof Text) {
            eResult.setName(((Text)c0).getTextTrim());
            return eResult;
        }
        Element e0 = XemeUtils.toElement(c0);
        if (e0.getChildren().size() < 1) {
            String aName = e0.getName();
            String aValue = e0.getTextTrim();
            eResult.setAttribute(aName, aValue);
            return eResult;
        }
        eResult.setName(e0.getName());
        Iterator it = e0.getChildren().iterator();
        while (it.hasNext()) {
            Element eChild = (Element)it.next();
            String aName = eChild.getName();
            String aValue = eChild.getTextTrim();
            eResult.setAttribute(aName, aValue);
        }
        return eResult;
    }

    public static Element xdr(Content c) {
        Element elt = XemeUtils.toElement(c);
        Element result = new Element(elt.getName());
        Iterator it = elt.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            Element e = new Element(a.getName());
            e.addContent((Content)new Text(a.getValue()));
            result.addContent((Content)e);
        }
        return result;
    }

    public static boolean isEmpty(Content c) {
        if (!(c instanceof Element)) {
            return true;
        }
        return ((Element)c).getChildren().size() < 1;
    }

    public static boolean isNull(Content c) {
        if (c == null) {
            return true;
        }
        log.debug((Object)("isNull() c is \n" + XmlUtils.xmlToString((Content)c)));
        if (c instanceof Element) {
            return ((Element)c).getContent().size() < 1;
        }
        if (c instanceof Text) {
            return c.equals((Object)NULL_RESULT);
        }
        log.debug((Object)"isNull() returning false (default).");
        return false;
    }

    public static boolean isAtom(Content c) {
        return !(c instanceof Element);
    }

    public static boolean isList(Content c) {
        return c instanceof Element;
    }

    public static Content fetchWorkitemResult(FlowExpression expression, InFlowWorkItem wi) {
        openwfe.org.engine.workitem.Attribute aResult = ValueUtils.getResult(wi);
        return XemeUtils.toXemeResult(expression, aResult);
    }

    public static Content toXemeResult(FlowExpression expression, Object o) {
        if (o == null) {
            return NULL_RESULT;
        }
        log.debug((Object)("toXemeResult() o.class is " + o.getClass().getName()));
        if (o instanceof Content) {
            return (Content)o;
        }
        if (o instanceof XmlAttribute) {
            return ((XmlAttribute)o).getContent();
        }
        if (o instanceof String || o instanceof StringAttribute) {
            String s = o.toString();
            if (s.equals("")) {
                return NULL_RESULT;
            }
            try {
                return XmlUtils.extractXmlElement((String)s);
            }
            catch (Throwable t) {
                log.debug((Object)"toXemeResult() String[Attribute] doesn't contain XML");
            }
        }
        if (o instanceof openwfe.org.engine.workitem.Attribute) {
            XmlWorkItemCoder coder = Definitions.getXmlCoder(expression.context());
            try {
                return coder.encodeAttribute((openwfe.org.engine.workitem.Attribute)o);
            }
            catch (Exception e) {
                log.debug((Object)"toXemeResult() couldn't code attribute", (Throwable)e);
                return NULL_RESULT;
            }
        }
        if (o instanceof FlowExpressionId) {
            return new Text("subprocess '" + o + "'");
        }
        if (o instanceof RawExpression) {
            return new Text("process '" + o + "'");
        }
        return new Text(o.toString());
    }

    public static Element toElement(Content c) {
        if (c instanceof Element) {
            return (Element)c.clone();
        }
        if (c instanceof Text) {
            String s = ((Text)c).getText();
            log.debug((Object)("toElement() text is >" + s + "<"));
            try {
                return XmlUtils.extractXmlElement((String)s);
            }
            catch (Exception e) {
                log.debug((Object)"toElement() couldn't fetch XML");
            }
        }
        throw new IllegalArgumentException("Not an element : " + c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

