/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ReflectionUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class SocketDispatcher
extends AbstractWorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$dispatch$SocketDispatcher == null ? (class$openwfe$org$engine$impl$dispatch$SocketDispatcher = SocketDispatcher.class$("openwfe.org.engine.impl.dispatch.SocketDispatcher")) : class$openwfe$org$engine$impl$dispatch$SocketDispatcher).getName());
    public static final String HOST = "host";
    public static final String PORT = "port";
    private static final int DEFAULT_PORT = 7007;
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    public static final String SOCKET_FACTORY = "socketFactory";
    public static final String RETRY_COUNT = "retryCount";
    private String targetHost = null;
    private int targetPort = -1;
    private int retryCount = 2;
    private int socketTimeout = 120000;
    private SocketFactory socketFactory = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$dispatch$SocketDispatcher;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.targetHost = (String)serviceParams.get(HOST);
        if (this.targetHost == null) {
            this.targetHost = "127.0.0.1";
        }
        this.targetPort = MapUtils.getAsInt((Map)serviceParams, (String)PORT, (int)7007);
        this.retryCount = MapUtils.getAsInt((Map)serviceParams, (String)RETRY_COUNT, (int)3);
        this.socketTimeout = MapUtils.getAsInt((Map)serviceParams, (String)SOCKET_TIMEOUT, (int)120000);
        String sFactoryClass = (String)serviceParams.get(SOCKET_FACTORY);
        try {
            this.socketFactory = (SocketFactory)ReflectionUtils.invokeStatic(Class.forName(sFactoryClass), (String)"getDefault", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            if (sFactoryClass != null) {
                log.warn((Object)("Failed to use custom SocketFactory '" + sFactoryClass + "'"), (Throwable)e);
            }
            this.socketFactory = SocketFactory.getDefault();
            log.debug((Object)("Using default socket factory '" + this.socketFactory.getClass().getName() + "'"));
        }
    }

    protected byte[] encodeWorkitem(WorkItemCoder coder, WorkItem wi) throws DispatchingException {
        long start = System.currentTimeMillis();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (wi instanceof InFlowWorkItem) {
                ((InFlowWorkItem)wi).setDispatchTime(Time.toIsoDate());
            }
            byte[] encodedWorkItem = (byte[])coder.encode(wi, this.getContext(), this.getParams());
            String ad = this.getWorkItemCoderName() + " " + encodedWorkItem.length + "\n\n";
            baos.write(ad.getBytes(Utils.getEncoding()));
            baos.write(encodedWorkItem);
            baos.flush();
            log.debug((Object)("encodeWorkitem() took " + (System.currentTimeMillis() - start)));
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new DispatchingException("Failed to encode workitem", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch(WorkItem wi) throws DispatchingException {
        log.debug((Object)("dispatch() to " + this.targetHost + ":" + this.targetPort));
        long start = System.currentTimeMillis();
        ListenerReply reply = null;
        WorkItemCoder coder = this.instantiateEncoder();
        byte[] encodedWorkitem = this.encodeWorkitem(coder, wi);
        for (int i = 0; i < this.retryCount; ++i) {
            log.debug((Object)("dispatch() attempt #" + i));
            Socket socket = null;
            OutputStream os = null;
            InputStream is = null;
            try {
                socket = this.socketFactory.createSocket(this.targetHost, this.targetPort);
                socket.setSoTimeout(this.socketTimeout);
                socket.setTcpNoDelay(true);
                os = socket.getOutputStream();
                is = socket.getInputStream();
                os.write(encodedWorkitem);
                os.flush();
                reply = coder.getReplyCoder().decode(is);
                if (reply instanceof WarningReply) {
                    WarningReply wr = (WarningReply)reply;
                    if (i == 0) {
                        log.warn((Object)("dispatch() problem \"" + wr.getMessage() + "\""));
                        if (wr.getCause() != null) {
                            log.warn((Object)"dispatch() problem", wr.getCause());
                        }
                    }
                    throw new DispatchingException("" + wr.getClass().getName() + "\n" + wr.getMessage());
                }
                log.debug((Object)("dispatch() #" + i + " is successful"));
                break;
            }
            catch (Throwable t) {
                log.info((Object)("dispatch() try #" + i), t);
                if (i >= this.retryCount - 1) {
                    throw new DispatchingException("last dispatch attempt failed", t);
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            finally {
                try {
                    os.flush();
                }
                catch (Throwable t) {}
                try {
                    socket.close();
                }
                catch (Throwable t) {}
            }
        }
        log.debug((Object)("dispatch() took " + (System.currentTimeMillis() - start)));
        return this.handleReply(reply);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

