/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.misc.Cache;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class CachedExpressionPool
extends SimpleExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$CachedExpressionPool == null ? (class$openwfe$org$engine$impl$expool$CachedExpressionPool = CachedExpressionPool.class$("openwfe.org.engine.impl.expool.CachedExpressionPool")) : class$openwfe$org$engine$impl$expool$CachedExpressionPool).getName());
    public static String P_CACHE_SIZE = "cacheSize";
    private int cacheSize = -1;
    private Cache cache = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$CachedExpressionPool;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.cacheSize = MapUtils.getAsInt((Map)serviceParams, (String)P_CACHE_SIZE, (int)500);
        this.cache = new Cache(this.cacheSize);
        log.info((Object)("init() " + P_CACHE_SIZE + " : " + this.cacheSize));
    }

    public Cache getCache() {
        return this.cache;
    }

    public void add(FlowExpression fe) throws PoolException {
        this.cache.put((Object)fe.getId(), (Object)fe);
        super.add(fe);
    }

    public void update(FlowExpression fe) throws PoolException {
        this.cache.put((Object)fe.getId(), (Object)fe);
        super.update(fe);
    }

    public FlowExpression fetch(FlowExpressionId fei) {
        log.debug((Object)("fetch() for " + fei));
        if (fei == null) {
            return null;
        }
        FlowExpression result = (FlowExpression)this.cache.get((Object)fei);
        if (result != null) {
            return result;
        }
        log.debug((Object)("fetch() not cached : " + fei));
        result = super.fetch(fei);
        if (result != null) {
            this.cache.put((Object)result.getId(), (Object)result);
        }
        return result;
    }

    public void removeExpression(FlowExpression fe) {
        log.debug((Object)("removeExpression() is fe null ? " + (fe == null)));
        this.cache.remove((Object)fe.getId());
        super.removeExpression(fe);
    }

    public Element getStatus() {
        Element result = super.getStatus();
        result.addContent((Content)this.cache.getStatus());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

