/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.InFlowObject;
import openwfe.org.engine.impl.expool.CachedExpressionPool;
import openwfe.org.engine.misc.ThreadedStorer;
import org.apache.log4j.Logger;

public class PerfExpressionPool
extends CachedExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$PerfExpressionPool == null ? (class$openwfe$org$engine$impl$expool$PerfExpressionPool = PerfExpressionPool.class$("openwfe.org.engine.impl.expool.PerfExpressionPool")) : class$openwfe$org$engine$impl$expool$PerfExpressionPool).getName());
    private ThreadedStorer ts = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$PerfExpressionPool;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.ts = new ThreadedStorer(){

            public InFlowObject doGet(FlowExpressionId fei) {
                try {
                    return PerfExpressionPool.this.getStore().loadExpression(fei);
                }
                catch (Throwable t) {
                    log.warn((Object)("doGet() failed to load " + fei), t);
                    return null;
                }
            }

            public void doStore(InFlowObject o) throws Exception {
                PerfExpressionPool.this.getStore().storeExpression((FlowExpression)o);
            }

            public void doRemove(InFlowObject o) throws Exception {
                PerfExpressionPool.this.getStore().unstoreExpression((FlowExpression)o);
            }
        };
    }

    public void add(FlowExpression fe) throws PoolException {
        fe.setApplicationContext(this.getContext());
        this.getCache().put((Object)fe.getId(), (Object)fe);
        this.ts.store(fe);
    }

    public void update(FlowExpression fe) throws PoolException {
        this.getCache().put((Object)fe.getId(), (Object)fe);
        this.ts.store(fe);
    }

    public FlowExpression fetch(FlowExpressionId fei) {
        if (fei == null) {
            return null;
        }
        FlowExpression result = (FlowExpression)this.getCache().get((Object)fei);
        if (result != null) {
            return result;
        }
        result = (FlowExpression)this.ts.get(fei);
        if (result != null) {
            this.getCache().put((Object)result.getId(), (Object)result);
        }
        return result;
    }

    public void removeExpression(FlowExpression fe) {
        this.getCache().remove((Object)fe.getId());
        this.ts.remove(fe);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

