/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.impl.launch.LibraryService;
import org.apache.log4j.Logger;

public class CronService
extends LibraryService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$launch$CronService == null ? (class$openwfe$org$engine$impl$launch$CronService = CronService.class$("openwfe.org.engine.impl.launch.CronService")) : class$openwfe$org$engine$impl$launch$CronService).getName());
    private TimerTask checkTask = null;
    private Map lastModificationTimes = new HashMap();
    static /* synthetic */ Class class$openwfe$org$engine$impl$launch$CronService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.checkTask = new TimerTask(){

            public void run() {
                try {
                    CronService.this.checkCrontab();
                }
                catch (Throwable t) {
                    log.warn((Object)"checkTask : problem", t);
                }
            }
        };
        Application.getTimer().schedule(this.checkTask, 60000L, 60000L);
        log.info((Object)("init() '" + serviceName + "' ready."));
    }

    public void stop() throws ServiceException {
        super.stop();
        this.checkTask.cancel();
        log.info((Object)"stop() check daemon stopped.");
        log.info((Object)("stop() Service '" + this.getName() + "' stopped."));
    }

    protected synchronized void checkCrontab() {
        Object o = this.getParams().get("url");
        ArrayList files = null;
        if (o instanceof List) {
            files = (ArrayList)o;
        } else {
            files = new ArrayList(1);
            files.add(o);
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            this.check((String)it.next());
        }
    }

    protected void check(String url) {
        String eUrl = Utils.expandUrl((String)url);
        Long lm0 = (Long)this.lastModificationTimes.get(eUrl);
        long lm1 = Utils.getLastModified((String)eUrl);
        if (lm0 == null || lm1 > lm0) {
            this.load(lm1, eUrl);
        }
    }

    protected void load(long lastModified, String url) {
        this.lastModificationTimes.put(url, new Long(lastModified));
        this.load(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

