/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.launch;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.DefineExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ProcessDefinition;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.launch.ProcessLibrary;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class SimpleXmlLauncher
extends AbstractService
implements Launcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$launch$SimpleXmlLauncher == null ? (class$openwfe$org$engine$impl$launch$SimpleXmlLauncher = SimpleXmlLauncher.class$("openwfe.org.engine.impl.launch.SimpleXmlLauncher")) : class$openwfe$org$engine$impl$launch$SimpleXmlLauncher).getName());
    public static final String VALIDATE = "openwfe.org.engine.launcher.validate";
    static /* synthetic */ Class class$openwfe$org$engine$impl$launch$SimpleXmlLauncher;

    public FlowExpressionId launch(LaunchItem li, boolean async) throws LaunchException {
        InFlowWorkItem wi = new InFlowWorkItem(li);
        return this.launch(wi, li.getReplyTo(), li.getWorkflowDefinitionUrl(), async);
    }

    private Element parseXmlDefinition(String url, InFlowWorkItem wi, boolean shouldValidate) throws Exception {
        if (url.startsWith("field:")) {
            String fieldName = url.substring(6);
            Attribute a = wi.getAttribute(fieldName);
            if (a == null) {
                throw new IllegalArgumentException("Field '" + fieldName + "' is not present, cannot launch flow defined in it");
            }
            if (a instanceof XmlAttribute) {
                Content content = ((XmlAttribute)a).getContent();
                return (Element)content;
            }
            String sXmlDefinition = a.toString();
            return XmlUtils.extractXmlElement((String)sXmlDefinition);
        }
        return XmlUtils.extractXml((String)url, (boolean)shouldValidate);
    }

    public FlowExpressionId launch(InFlowWorkItem wi, FlowExpressionId parentId, String wfdUrl, boolean async) throws LaunchException {
        if (wfdUrl.indexOf("::") > -1) {
            String wfid = this.launchExternalProcess(wi, wfdUrl, parentId);
            FlowExpressionId result = new FlowExpressionId();
            result.setOwfeVersion("1.7.0pre9");
            result.setWorkflowInstanceId(wfid);
            return result;
        }
        String url = Utils.expandUrl((String)wfdUrl);
        log.debug((Object)("launch() request for " + url));
        try {
            Element elt = this.parseXmlDefinition(url, wi, SimpleXmlLauncher.shouldValidate());
            RawExpression rootExpression = RawExpression.getEmptyRawExpression(this.getContext());
            String wfdName = elt.getAttributeValue("name");
            String wfdRevision = elt.getAttributeValue("revision");
            if (wfdName == null || wfdRevision == null) {
                throw new LaunchException("Process definition is missing a 'name' and/or a 'revision' attribute.");
            }
            if (parentId == null) {
                FlowExpressionId pid = new FlowExpressionId();
                pid.setOwfeVersion("1.7.0pre9");
                pid.setEngineId(this.getContext().getApplicationName());
                pid.setInitialEngineId(this.getContext().getApplicationName());
                pid.setWorkflowDefinitionUrl(url);
                pid.setWorkflowDefinitionName(wfdName);
                pid.setWorkflowDefinitionRevision(wfdRevision);
                pid.setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
                rootExpression.init(this.getContext(), null, pid, 0, (Object)elt);
            } else {
                FlowExpressionId id = new FlowExpressionId();
                id.setOwfeVersion("1.7.0pre9");
                id.setEngineId(this.getContext().getApplicationName());
                id.setInitialEngineId(this.getContext().getApplicationName());
                id.setWorkflowDefinitionUrl(url);
                id.setWorkflowDefinitionName(wfdName);
                id.setWorkflowDefinitionRevision(wfdRevision);
                id.setExpressionName(elt.getName());
                id.setExpressionId("0");
                id.setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
                rootExpression.init(this.getContext(), null, parentId, id, (Object)elt);
            }
            this.getExpressionPool().add(rootExpression);
            HashMap<String, Object> vars = new HashMap<String, Object>(1);
            vars.put(wfdName, rootExpression.clone());
            log.debug((Object)("launch() '" + wfdName + "' -> " + rootExpression.getId()));
            FlowExpressionId fei = this.launchSub(wi, parentId, rootExpression.getId(), vars, async);
            log.debug((Object)("launch() launched as sub : " + fei));
            log.debug((Object)("launch() returning :       " + fei.getWorkflowInstanceId()));
            return fei;
        }
        catch (Throwable t) {
            throw new LaunchException("launch failed", t);
        }
    }

    public FlowExpressionId launchSub(InFlowWorkItem wi, FlowExpressionId parentId, FlowExpressionId templateId, Map variables, boolean async) throws LaunchException {
        this.loadLibrary();
        log.debug((Object)("launchSub() for template " + templateId));
        log.debug((Object)("launchSub() parentId is " + parentId));
        RawExpression rawExp = (RawExpression)this.getExpressionPool().fetch(templateId);
        try {
            rawExp = rawExp.newInstance(parentId);
            log.debug((Object)("launchSub() rawExp.parent was " + rawExp.getParent()));
            rawExp.setParent(parentId);
            Environment env = Environment.generateEnvironment(rawExp);
            rawExp.storeItself();
            log.debug((Object)("launchSub() generated env : " + env.getId()));
            if (variables != null) {
                env.putAll(variables);
                env.storeItself();
            }
            final FlowExpressionId id = rawExp.getId();
            log.debug((Object)("launchSub() rawExp.id is     " + id));
            log.debug((Object)("launchSub() rawExp.parent is " + rawExp.getParent()));
            final InFlowWorkItem subwi = (InFlowWorkItem)wi.clone();
            log.debug((Object)("launchSub() applying " + id));
            log.debug((Object)("launchSub() async ?  " + async));
            if (async) {
                new Thread(){

                    public void run() {
                        try {
                            log.debug((Object)"launchSub()  (now in async thread)");
                            SimpleXmlLauncher.this.getExpressionPool().apply(id, subwi);
                            log.debug((Object)("launchSub() applied " + id));
                        }
                        catch (Throwable t) {
                            log.warn((Object)"launchSub() failure", t);
                        }
                    }
                }.start();
            } else {
                this.getExpressionPool().apply(id, subwi);
            }
            log.debug((Object)("launchSub() applied " + id.getWorkflowInstanceId()));
            return id;
        }
        catch (Exception e) {
            log.debug((Object)"Failed to 'launch' RawExpression", (Throwable)e);
            throw new LaunchException("Failed to 'launch' RawExpression", e);
        }
    }

    public Map fetchAttributes(FlowExpression fe, Object rawExpression) throws BuildException {
        if (rawExpression instanceof Map) {
            return (Map)rawExpression;
        }
        Element e = (Element)rawExpression;
        Map result = XmlUtils.fetchAttributes((Element)e);
        if (fe instanceof WithChildren) {
            String text = e.getTextTrim();
            if (text != null && text.length() > 0 && e.getChildren().size() < 1) {
                result.put("__value__", e.getTextTrim());
                result.put("__content__", XmlUtils.xmlToString((Content)e));
            } else if (e.getContent().size() > 0) {
                result.put("__content__", XmlUtils.xmlToString((Content)e));
            }
        }
        return result;
    }

    public ProcessDefinition loadProcessDefinition(String wfdUrl) throws BuildException {
        String url = Utils.expandUrl((String)wfdUrl);
        Element elt = null;
        try {
            elt = XmlUtils.extractXml((String)url, (boolean)SimpleXmlLauncher.shouldValidate());
        }
        catch (Throwable t) {
            throw new BuildException("Failed to load " + url, t);
        }
        return this.loadProcessDefinition(url, null, elt);
    }

    public ProcessDefinition loadProcessDefinition(FlowExpressionId parentId, Object rawExpression) throws BuildException {
        return this.loadProcessDefinition(null, parentId, (Element)rawExpression);
    }

    private ProcessDefinition loadProcessDefinition(String wfdUrl, FlowExpressionId parentId, Element elt) throws BuildException {
        String wfdName = null;
        String wfdRevision = null;
        FlowExpressionId pId = parentId;
        if (pId == null) {
            pId = new FlowExpressionId();
            wfdName = elt.getAttributeValue("name");
            wfdRevision = elt.getAttributeValue("revision");
            pId.setOwfeVersion("1.7.0pre9");
            pId.setWorkflowDefinitionUrl(wfdUrl);
            pId.setWorkflowDefinitionName(wfdName);
            pId.setWorkflowDefinitionRevision(wfdRevision);
        } else {
            wfdName = pId.getWorkflowDefinitionName();
            wfdRevision = pId.getWorkflowDefinitionRevision();
        }
        try {
            RawExpression rootExpression = RawExpression.getEmptyRawExpression(this.getContext());
            rootExpression.init(this.getContext(), null, pId, 0, (Object)elt);
            ProcessDefinition result = new ProcessDefinition(this.getContext(), wfdUrl, wfdName, wfdRevision);
            FlowExpression fe = rootExpression.resolveExpression(result);
            log.debug((Object)("loadProcessDefinition() found something of class >" + fe.getClass().getName() + "<"));
            result.setSelf((DefineExpression)fe);
            return result;
        }
        catch (Throwable t) {
            throw new BuildException("Failed to load " + wfdUrl, t);
        }
    }

    public ProcessDefinition loadProcessDefinitionFromString(String xmlDefinition) throws BuildException {
        try {
            return this.loadProcessDefinition(null, XmlUtils.extractXmlDocument((String)xmlDefinition, (boolean)SimpleXmlLauncher.shouldValidate()).getRootElement());
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException("Failed to extract xml from string xml definition", e);
        }
    }

    public RawExpression eval(FlowExpression caller, Object rawScript, InFlowWorkItem wi) throws Exception {
        if (rawScript == null) {
            log.debug((Object)"eval() nothing to eval.");
            return null;
        }
        if (rawScript instanceof Text) {
            String varName = ((Text)rawScript).getTextTrim();
            Object o = caller.lookupVariable(varName);
            if (o != null) {
                ValueUtils.setResult(wi, AttributeUtils.java2owfe(o));
            }
            log.debug((Object)"eval() just some text.");
            return null;
        }
        if (!(rawScript instanceof Element)) {
            throw new ApplyException("cannot handle XML fragment of class " + rawScript.getClass().getName());
        }
        log.debug((Object)("eval() xml is \n" + XmlUtils.xmlToString((Content)((Content)rawScript))));
        RawExpression evalResult = RawExpression.getEmptyRawExpression(caller.context());
        evalResult.init(caller.context(), caller.getEnvironmentId(), caller.getId(), 0, rawScript);
        this.getExpressionPool().add(evalResult);
        return evalResult;
    }

    protected ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool(this.getContext());
    }

    protected ParticipantMap getParticipantMap() {
        return Definitions.getParticipantMap(this.getContext());
    }

    protected String launchExternalProcess(InFlowWorkItem wi, String ref, FlowExpressionId parentId) throws LaunchException {
        String[] ss = ref.split("::");
        String engineId = ss[0];
        String processUrl = ss[1];
        log.debug((Object)("launchExternalProcess() engineId     >" + engineId + "<"));
        log.debug((Object)("launchExternalProcess() processUrl   >" + processUrl + "<"));
        Participant participant = this.getParticipantMap().get(engineId);
        LaunchItem li = new LaunchItem(processUrl, parentId, wi);
        try {
            Object o = participant.dispatch(this.getContext(), li);
            return o.toString();
        }
        catch (DispatchingException de) {
            throw new LaunchException("Dispatching (launch) to engine '" + engineId + "' failed", (Throwable)((Object)de));
        }
        catch (Throwable t) {
            log.warn((Object)"launchExternalProcess() unexpected exception", t);
            log.warn((Object)"launchExternalProcess() returning flowInstanceId = null");
            return null;
        }
    }

    private void loadLibrary() throws LaunchException {
        ProcessLibrary lib = (ProcessLibrary)this.getContext().get("processLibrary");
        if (lib == null) {
            return;
        }
        lib.load();
    }

    public static boolean shouldValidate() {
        String s = System.getProperty(VALIDATE);
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase()).equals("true") || s.equals("yes") || s.equals("ok") || s.equals("validate");
    }

    public static Map extractXmlDescription(String processDefinitionUrl) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Element root = XmlUtils.extractXml((URL)new URL(processDefinitionUrl), (boolean)false);
            result.put("root.element.name", root.getName());
            Iterator it = root.getChildren("description").iterator();
            while (it.hasNext()) {
                Element description = (Element)it.next();
                String dLanguage = description.getAttributeValue("language");
                String descriptionText = description.getTextNormalize();
                if (dLanguage == null) {
                    result.put("default", descriptionText);
                    continue;
                }
                result.put(dLanguage, descriptionText);
            }
            return result;
        }
        catch (Exception e) {
            log.info((Object)("Failed to load description from " + processDefinitionUrl), (Throwable)e);
            return new HashMap(0);
        }
    }

    public static String extractXmlDescription(String processDefinitionUrl, String language) {
        Map descriptionMap = SimpleXmlLauncher.extractXmlDescription(processDefinitionUrl);
        if (language == null) {
            return (String)descriptionMap.get("default");
        }
        String description = (String)descriptionMap.get(language);
        if (description != null) {
            return description;
        }
        return (String)descriptionMap.get("default");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

