/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.TimerTask;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.workitem.WorkItemCoder;
import org.apache.log4j.Logger;

public class FileListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$FileListener == null ? (class$openwfe$org$engine$impl$listen$FileListener = FileListener.class$("openwfe.org.engine.impl.listen.FileListener")) : class$openwfe$org$engine$impl$listen$FileListener).getName());
    public static final String P_DIRECTORY = "directory";
    public static final String P_FREQUENCY = "frequency";
    private static final String DEFAULT_FREQUENCY = "10s";
    private String directory = null;
    private TimerTask listenTask = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$FileListener;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.directory = MapUtils.getAsString((Map)serviceParams, (String)P_DIRECTORY, (String)"in/");
        if (!this.directory.startsWith(File.separator)) {
            this.directory = this.getContext().getApplicationDirectory() + this.directory;
        }
        log.info((Object)("Input directory set to " + this.directory));
        long frequency = MapUtils.getAsTime((Map)serviceParams, (String)P_FREQUENCY, (String)DEFAULT_FREQUENCY);
        this.listenTask = new TimerTask(){

            public void run() {
                FileListener.this.load();
            }
        };
        Application.getTimer().schedule(this.listenTask, 10L, frequency);
    }

    public void stop() throws ServiceException {
        super.stop();
        this.listenTask.cancel();
        log.info((Object)("'" + this.getName() + "' Stopped."));
    }

    protected void load() {
        try {
            File dir = new File(this.directory);
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.loadFile(files[i]);
            }
        }
        catch (Throwable t) {
            log.warn((Object)"load() failure", t);
        }
    }

    protected void loadFile(File f) {
        if (f.isDirectory()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(f);
            WorkItemCoder coder = (WorkItemCoder)this.determineCoderAndLength(is)[0];
            this.getConsumer().use(coder.decode(is, this.getContext(), this.getParams()));
            f.delete();
        }
        catch (Exception e) {
            log.info((Object)("Rejecting item " + f.getPath()), (Throwable)e);
            Utils.move((File)f, (String)(this.directory + "rejected/" + f.getName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

