/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.FactoryException;
import openwfe.org.ServiceException;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMapFactory;
import org.apache.log4j.Logger;

public class CompositeParticipantMap
extends AbstractParticipantMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$CompositeParticipantMap == null ? (class$openwfe$org$engine$impl$participants$CompositeParticipantMap = CompositeParticipantMap.class$("openwfe.org.engine.impl.participants.CompositeParticipantMap")) : class$openwfe$org$engine$impl$participants$CompositeParticipantMap).getName());
    public static final String P_FACTORY = "factory";
    private List factoryNames = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$CompositeParticipantMap;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.factoryNames = new ArrayList(3);
        Object o = serviceParams.get(P_FACTORY);
        if (o instanceof List) {
            this.factoryNames.addAll((List)o);
        } else {
            this.factoryNames.add(o);
        }
        this.reload();
    }

    protected void refreshMap() throws ServiceException {
        boolean shouldRefresh = false;
        Iterator it = this.lookupFactories().iterator();
        while (it.hasNext()) {
            ParticipantMapFactory factory = (ParticipantMapFactory)it.next();
            try {
                if (!factory.hasSourceChanged()) continue;
                shouldRefresh = true;
                break;
            }
            catch (FactoryException e) {
                log.warn((Object)"refreshMap() problem with a ParticipantMapFactory", (Throwable)e);
                throw new ServiceException("problem with a ParticipantMapFactory", (Throwable)e);
            }
        }
        if (shouldRefresh) {
            log.debug((Object)"refreshMap() yes, reloading participants is necessary...");
            this.reload();
        }
    }

    public List getFactoryNames() {
        return this.factoryNames;
    }

    protected ParticipantMapFactory lookupFactory(String factoryName) {
        return (ParticipantMapFactory)this.getContext().lookup(factoryName);
    }

    protected List lookupFactories() {
        ArrayList<ParticipantMapFactory> l = new ArrayList<ParticipantMapFactory>(this.factoryNames.size());
        Iterator it = this.factoryNames.iterator();
        while (it.hasNext()) {
            String factoryName = (String)it.next();
            ParticipantMapFactory factory = this.lookupFactory(factoryName);
            if (factory == null) {
                log.warn((Object)("lookupFactories() no ParticipantMapFactory named '" + factoryName + "' found."));
                continue;
            }
            l.add(factory);
        }
        return l;
    }

    protected void reload() throws ServiceException {
        log.info((Object)"reload()");
        this.getParticipants().clear();
        Iterator it = this.lookupFactories().iterator();
        while (it.hasNext()) {
            ParticipantMapFactory factory = (ParticipantMapFactory)it.next();
            List participants = null;
            try {
                participants = factory.createParticipants(this);
            }
            catch (FactoryException e) {
                log.warn((Object)"reload() problem creating participants", (Throwable)e);
                throw new ServiceException("problem creating participants", (Throwable)e);
            }
            Iterator pit = participants.iterator();
            while (pit.hasNext()) {
                Participant p = (Participant)pit.next();
                this.add(p);
                log.info((Object)("reload() added participant '" + p.getRegex() + "'"));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

