/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.misc;

import java.util.HashSet;
import java.util.Set;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.InFlowObject;
import org.apache.log4j.Logger;

public abstract class ThreadedStorer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$misc$ThreadedStorer == null ? (class$openwfe$org$engine$misc$ThreadedStorer = ThreadedStorer.class$("openwfe.org.engine.misc.ThreadedStorer")) : class$openwfe$org$engine$misc$ThreadedStorer).getName());
    private Set inStorage = new HashSet();
    private Set inDeletion = new HashSet();
    static /* synthetic */ Class class$openwfe$org$engine$misc$ThreadedStorer;

    public InFlowObject get(FlowExpressionId fei) {
        if (this.inDeletion.contains(fei)) {
            log.debug((Object)("get() prevented dirty-read for " + fei));
            return null;
        }
        return this.doGet(fei);
    }

    public void store(final InFlowObject o) {
        final FlowExpressionId id = o.getId();
        if (this.inStorage.contains(id)) {
            log.debug((Object)"store() discarding supplemental store() request");
            return;
        }
        new Thread(){

            public void run() {
                try {
                    ThreadedStorer.this.doStore(o);
                }
                catch (Throwable t) {
                    log.warn((Object)("store() failure for " + o.getId()), t);
                }
                ThreadedStorer.this.inStorage.remove(id);
                log.debug((Object)"store() thread done.");
            }
        }.start();
        log.debug((Object)"store() done.");
    }

    public void remove(final InFlowObject o) {
        new Thread(){

            public void run() {
                FlowExpressionId fei = o.getId();
                try {
                    ThreadedStorer.this.inDeletion.add(fei);
                    ThreadedStorer.this.doRemove(o);
                    ThreadedStorer.this.inDeletion.remove(fei);
                    log.debug((Object)"remove() thread done.");
                }
                catch (Throwable t) {
                    log.warn((Object)("remove() failure for " + fei), t);
                }
            }
        }.start();
        log.debug((Object)"remove() done.");
    }

    public abstract InFlowObject doGet(FlowExpressionId var1);

    public abstract void doStore(InFlowObject var1) throws Exception;

    public abstract void doRemove(InFlowObject var1) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

