/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.engine.expool.ExpressionStore;
import openwfe.org.engine.expressions.CompositeFlowExpression;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.engine.impl.expool.XmlExpressionStore;
import openwfe.org.time.Time;

public class PoolGrapher {
    private static ApplicationContext applicationContext = new ApplicationContext();
    private static Map pool = new HashMap();
    private static boolean printOwfeVersion = false;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$XmlExpressionStore;
    static /* synthetic */ Class class$openwfe$org$engine$tools$PoolGrapher;

    private static ExpressionStore getExpressionStore(String storeClassName, Map storeParams) throws Exception {
        Class<?> storeClass = Class.forName(storeClassName);
        ExpressionStore store = (ExpressionStore)storeClass.newInstance();
        if (storeClass.equals(class$openwfe$org$engine$impl$expool$XmlExpressionStore == null ? (class$openwfe$org$engine$impl$expool$XmlExpressionStore = PoolGrapher.class$("openwfe.org.engine.impl.expool.XmlExpressionStore")) : class$openwfe$org$engine$impl$expool$XmlExpressionStore) && storeParams.size() < 1) {
            storeParams.put(XmlExpressionStore.P_WORK_DIRECTORY, "./work/engine/pool");
        }
        ((Service)store).init("expressionStore", applicationContext, storeParams);
        return store;
    }

    private static void printUsage(String cmd) {
        System.out.println();
        System.out.println("Usage :");
        System.out.println();
        System.out.println("   " + cmd + " [-s storeClassName] {-paramName paramValue}* {wfid}*");
        System.out.println();
        System.out.println("   will print out a list of the expression in the pool an how they are linked");
        System.out.println();
        System.out.println("      -s storeClassName");
        System.out.println("           sets the store class to use (by default, it's XmlExpressionStore");
        System.out.println("      -V");
        System.out.println("           prints the OpenWFE version for each expression");
        System.out.println("      -paramName paramValue");
        System.out.println("           passes parameters to the store");
        System.out.println();
        System.out.println("      -h");
        System.out.println("           prints this usage and exits");
        System.out.println();
        System.out.println("   (1.7.0pre9)");
        System.out.println();
        System.exit(-1);
    }

    private static void putExpression(String wfids, FlowExpression fe) {
        Long wfid = new Long(fe.getId().getParentWorkflowInstanceId());
        String sWfid = "" + wfid;
        if (wfids != null && wfids.indexOf(sWfid) < 0) {
            return;
        }
        HashMap<FlowExpressionId, FlowExpression> flowInstance = (HashMap<FlowExpressionId, FlowExpression>)pool.get(wfid);
        if (flowInstance == null) {
            flowInstance = new HashMap<FlowExpressionId, FlowExpression>();
            pool.put(wfid, flowInstance);
        }
        flowInstance.put(fe.getId(), fe);
    }

    private static void renderPool() {
        System.out.println("digraph OpenWFE_expression_pool {");
        System.out.println("    rankdir=LR;");
        System.out.println("    node [shape = ellipse, color = gray85 ];");
        Iterator it = pool.keySet().iterator();
        while (it.hasNext()) {
            Map flowInstance = (Map)pool.get(it.next());
            PoolGrapher.renderFlowInstance(flowInstance);
        }
        System.out.println("}");
    }

    private static void renderFlowInstance(Map flowInstance) {
        String sortKey;
        HashMap<String, FlowExpressionId> m = new HashMap<String, FlowExpressionId>();
        Iterator<Object> it = flowInstance.keySet().iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            sortKey = fei.getWorkflowInstanceId() + "_" + fei.getExpressionId();
            m.put(sortKey, fei);
        }
        ArrayList l = new ArrayList(m.keySet());
        Collections.sort(l);
        it = l.iterator();
        while (it.hasNext()) {
            sortKey = (String)it.next();
            FlowExpressionId fei = (FlowExpressionId)m.get(sortKey);
            PoolGrapher.renderExpression((FlowExpression)flowInstance.get(fei));
        }
    }

    private static String id(FlowExpressionId fei) {
        StringBuffer sb = new StringBuffer();
        sb.append(fei.getWorkflowInstanceId()).append("_").append(fei.getExpressionName()).append("_").append(fei.getExpressionId());
        sb.append("\\n");
        sb.append(fei.getWorkflowDefinitionName()).append(" ").append(fei.getWorkflowDefinitionRevision());
        if (printOwfeVersion) {
            sb.append(" (").append(fei.getOwfeVersion()).append(")");
        }
        return sb.toString();
    }

    private static void printLink(FlowExpressionId from, FlowExpressionId to, String label) {
        if (from == null || to == null) {
            return;
        }
        System.out.print("    ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(from));
        System.out.print("\"");
        System.out.print(" -> ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(to));
        System.out.print("\"");
        System.out.print(" [ label = \"" + label + "\" ];");
        System.out.println();
    }

    private static void printLabel(FlowExpression fe) {
        ParticipantExpression pe;
        StringBuffer sb = new StringBuffer();
        sb.append(PoolGrapher.id(fe.getId()));
        sb.append("\\n").append(fe.getClass().getName());
        ArrayList atts = new ArrayList(fe.getAttributes().keySet());
        Collections.sort(atts);
        Iterator it = atts.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)fe.getAttributes().get(key);
            sb.append("\\n").append(key).append(" = ").append("'").append(value).append("'");
        }
        boolean applied = false;
        if (fe instanceof ParticipantExpression && (pe = (ParticipantExpression)fe).getAppliedWorkitem() != null) {
            applied = true;
            sb.append("\\n").append("*applied*");
        }
        if (fe.getState() != null) {
            String since = Time.toIsoDate((long)fe.getState().getSince());
            sb.append("\\n").append(fe.getState().getName()).append(" since ").append(since);
        }
        System.out.print("    ");
        System.out.print("\"");
        System.out.print(PoolGrapher.id(fe.getId()));
        System.out.print("\"");
        System.out.print(" [ label = \"" + sb.toString() + "\"");
        if (fe instanceof Environment) {
            System.out.print(" shape = rect ");
        }
        if (applied) {
            System.out.print(" color = red ");
        } else {
            System.out.print(" color = black ");
        }
        System.out.print("];");
        System.out.println();
    }

    private static void renderExpression(FlowExpression fe) {
        ExpressionState state = SimpleExpressionPool.getState(fe);
        String since = Time.toIsoDate((long)state.getSince());
        FlowExpressionId fei = fe.getId();
        PoolGrapher.printLabel(fe);
        PoolGrapher.printLink(fei, fe.getParent(), "parent");
        if (Environment.ownsEnvironment(fe)) {
            PoolGrapher.printLink(fei, fe.getEnvironmentId(), "env");
        }
        if (fe instanceof CompositeFlowExpression) {
            Iterator it = ((CompositeFlowExpression)((Object)fe)).getChildren().iterator();
            while (it.hasNext()) {
                FlowExpressionId childId = (FlowExpressionId)it.next();
                PoolGrapher.printLink(fei, childId, "child");
            }
        } else if (fe instanceof OneChildExpression) {
            FlowExpressionId childId = ((OneChildExpression)fe).getChildExpressionId();
            PoolGrapher.printLink(fei, childId, "child");
        }
    }

    public static void main(String[] args) throws Exception {
        String cmd = "java " + (class$openwfe$org$engine$tools$PoolGrapher == null ? (class$openwfe$org$engine$tools$PoolGrapher = PoolGrapher.class$("openwfe.org.engine.tools.PoolGrapher")) : class$openwfe$org$engine$tools$PoolGrapher).getName();
        int index = 0;
        if (args.length < 1) {
            PoolGrapher.printUsage(cmd);
        }
        if (!args[0].startsWith("-")) {
            cmd = args[0];
            index = 1;
        }
        String storeClassName = (class$openwfe$org$engine$impl$expool$XmlExpressionStore == null ? (class$openwfe$org$engine$impl$expool$XmlExpressionStore = PoolGrapher.class$("openwfe.org.engine.impl.expool.XmlExpressionStore")) : class$openwfe$org$engine$impl$expool$XmlExpressionStore).getName();
        HashMap<String, String> storeParams = new HashMap<String, String>();
        while (index < args.length && args[index].startsWith("-")) {
            String arg = args[index];
            if (arg.equals("-h")) {
                PoolGrapher.printUsage(cmd);
            }
            if (arg.equals("-s")) {
                storeClassName = args[index + 1];
            } else if (arg.equals("-V")) {
                printOwfeVersion = true;
            } else {
                storeParams.put(args[index].substring(1), args[index + 1]);
            }
            index += 2;
        }
        String wfids = null;
        while (index < args.length) {
            if (wfids == null) {
                wfids = "";
            }
            wfids = wfids + args[index];
            wfids = wfids + " ";
            ++index;
        }
        applicationContext.setApplicationName("tool:" + (class$openwfe$org$engine$tools$PoolGrapher == null ? (class$openwfe$org$engine$tools$PoolGrapher = PoolGrapher.class$("openwfe.org.engine.tools.PoolGrapher")) : class$openwfe$org$engine$tools$PoolGrapher).getName());
        ExpressionStore es = PoolGrapher.getExpressionStore(storeClassName, storeParams);
        Iterator it = es.contentIterator(null);
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            PoolGrapher.putExpression(wfids, fe);
        }
        PoolGrapher.renderPool();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

