/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.tools;

import java.io.File;
import openwfe.org.xml.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;

public class WiMerge {
    private static Element merge(Element eWi1, Element eWi2) {
        Element eLastExpressionId1 = eWi1.getChild("last-expression-id");
        Element eLastExpressionId2 = eWi2.getChild("last-expression-id");
        eLastExpressionId1.detach();
        eLastExpressionId2.detach();
        eWi2.addContent((Content)eLastExpressionId1);
        return eWi2;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("  USAGE :");
        System.out.println();
        System.out.println("  java WiMerge {wi-source} {wi-target} {dump-dir}");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String dumpDirPath;
        if (args.length < 3) {
            WiMerge.printUsage();
        }
        int index = 0;
        String sourceFilename = args[index++];
        String targetFilename = args[index++];
        if (!(dumpDirPath = args[index++]).endsWith(File.separator)) {
            dumpDirPath = dumpDirPath + File.separator;
        }
        File sourceFile = new File(sourceFilename);
        File targetFile = new File(targetFilename);
        Element eWi1 = XmlUtils.extractXml((String)sourceFilename, (boolean)false);
        Element eWi2 = XmlUtils.extractXml((String)targetFilename, (boolean)false);
        Element eWi3 = WiMerge.merge(eWi1, eWi2);
        String dumpFilename = dumpDirPath + sourceFile.getName();
        XmlUtils.save((String)dumpFilename, (Element)eWi3);
        System.out.println("...dumped new workitem into " + dumpFilename);
    }
}

