/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XmlCoderLoader
extends AbstractService
implements WorkItemCoderLoader {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$workitem$XmlCoderLoader == null ? (class$openwfe$org$engine$workitem$XmlCoderLoader = XmlCoderLoader.class$("openwfe.org.engine.workitem.XmlCoderLoader")) : class$openwfe$org$engine$workitem$XmlCoderLoader).getName());
    protected static final String DEFAULT = "__default__";
    protected static final String XML = "__xml__";
    private Map map = null;
    static /* synthetic */ Class class$openwfe$org$engine$workitem$XmlCoderLoader;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        Object oConf = serviceParams.get("configurationFile");
        if (oConf == null) {
            throw new ServiceException("parameter configurationFile' is mandatory for service " + this.getName() + " (" + this.getClass().getName() + ")");
        }
        log.debug((Object)("init() oConf is instance of " + oConf.getClass().getName()));
        Object confFileNames = null;
        if (oConf instanceof List) {
            Iterator it = ((List)oConf).iterator();
            while (it.hasNext()) {
                this.loadConfigurationFile((String)it.next());
            }
        } else {
            this.loadConfigurationFile((String)oConf);
        }
    }

    public WorkItemCoder getDefaultCoder() {
        return (WorkItemCoder)this.map.get(DEFAULT);
    }

    public WorkItemCoder getXmlCoder() {
        return (WorkItemCoder)this.map.get(XML);
    }

    public WorkItemCoder getCoder(String name) {
        return (WorkItemCoder)this.map.get(name);
    }

    protected void loadConfigurationFile(String fileName) throws ServiceException {
        if (this.map == null) {
            this.map = new HashMap();
        }
        try {
            log.info((Object)("loadConfigurationFile() raw  " + fileName));
            String fn = Utils.expandUrl((String)fileName);
            log.info((Object)("loadConfigurationFile()      " + fn));
            Element root = XmlUtils.extractXml((String)fn, (boolean)false);
            Iterator it = root.getChildren("workitem-coder").iterator();
            while (it.hasNext()) {
                this.buildCoderConfiguration((Element)it.next());
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build AttributeCoder list from file '" + fileName + "'", (Throwable)e);
        }
    }

    protected void buildCoderConfiguration(Element conf) throws ServiceException {
        String name = conf.getAttributeValue("name");
        String className = conf.getAttributeValue("class");
        String sDefault = conf.getAttributeValue("default");
        if (name == null || className == null) {
            throw new ServiceException("Attribute 'name' or 'class' is missing from WorkItemCoder configuration file");
        }
        log.info((Object)("building coder '" + name + "'"));
        WorkItemCoder workItemCoder = null;
        try {
            Class<?> coderClass = Class.forName(className);
            workItemCoder = (WorkItemCoder)coderClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to instantiate coder '" + name + "' with class '" + className + "'", (Throwable)e);
        }
        log.debug((Object)"buildCoderConfiguration() workItemCoder instantiated");
        ArrayList<AttributeCoder> attributeList = new ArrayList<AttributeCoder>();
        Iterator it = conf.getChildren("attribute-coder").iterator();
        while (it.hasNext()) {
            AttributeCoder attributeCoder = this.buildAttributeCoder(workItemCoder, (Element)it.next());
            attributeList.add(attributeCoder);
        }
        log.debug((Object)"buildCoderConfiguration() attributeList filled");
        Element elt = conf.getChild("reply-coder");
        if (elt == null) {
            throw new ServiceException("Element 'replyCoder' is mandatory in coder configuration. It is missing for coder '" + name + "'");
        }
        String replyCoderClassName = elt.getAttributeValue("class");
        ListenerReplyCoder replyCoder = null;
        try {
            Class<?> replyCoderClass = Class.forName(replyCoderClassName);
            replyCoder = (ListenerReplyCoder)replyCoderClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to instantiate coder '" + name + "' listenerReplyCoder with class '" + replyCoderClassName + "'", (Throwable)e);
        }
        log.debug((Object)"buildCoderConfiguration() replyCoder instantiated");
        workItemCoder.init(name, attributeList, replyCoder);
        log.debug((Object)"buildCoderConfiguration() workItemCoder initialized");
        this.map.put(name, workItemCoder);
        log.info((Object)("Built workItemCoder '" + name + "'"));
        if (sDefault != null && sDefault.trim().toLowerCase().equals("true")) {
            log.info((Object)("Setting workItemCoder '" + name + "' as default"));
            this.map.put(DEFAULT, workItemCoder);
        }
        if (workItemCoder instanceof XmlWorkItemCoder) {
            log.info((Object)("Setting workItemCoder '" + name + "' as xmlCoder"));
            this.map.put(XML, workItemCoder);
        }
    }

    protected AttributeCoder buildAttributeCoder(WorkItemCoder workItemCoder, Element conf) throws ServiceException {
        String coderClassName = conf.getAttributeValue("class");
        if (coderClassName == null) {
            throw new ServiceException("Attribute 'coderClass' is missing from AttributeCoder configuration");
        }
        log.debug((Object)("buildAttributeCoder() coderClassName is " + coderClassName));
        AttributeCoder coder = null;
        try {
            Class<?> coderClass = Class.forName(coderClassName);
            coder = (AttributeCoder)coderClass.newInstance();
            Map params = Parameters.extractAttributes((Element)conf);
            coder.init(workItemCoder, params);
        }
        catch (Exception e) {
            throw new ServiceException("Failed to instantiate AttributeCoder for class '" + coderClassName + "'", (Throwable)e);
        }
        return coder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

