//
// TestCase.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine._test;

import junit.framework.Assert;

import openwfe.org.Utils;
import openwfe.org.engine.workitem.*;
import openwfe.org.engine.expressions.*;


/**
 * The test cases for the package
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: ValueUtilsCase.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class ValueUtilsCase

    extends junit.framework.TestCase

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ValueUtilsCase.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public ValueUtilsCase (String name)
    {
        super(name);
    }

    //
    // METHODS

    public void setUp ()
    {
    }

    public void tearDown ()
    {
    }

    //
    // TEST METHODS

    public void testDetermineValue ()
        throws Exception
    {
        FlowExpression fe = new SetValueExpression();
        fe.setAttributes(new java.util.HashMap(1));
        fe.getAttributes().put("field-value", "toto");

        log.debug("FlowExpression ready");

        InFlowWorkItem wi = new InFlowWorkItem();
        wi.setAttributes(new StringMapAttribute());
        wi.getAttributes().puts("toto", "toto-value");

        log.debug("Workitem ready");

        Object v = ValueUtils.determineValue(fe, wi);

        Assert.assertTrue
            ("Value is not null", 
             v != null);

        Assert.assertTrue
            ("Value is Attribute", 
             (v instanceof Attribute));

        log.debug("Value is "+v);
    }

    public void testDetermineValueWhenNull ()
        throws Exception
    {
        FlowExpression fe = new SetValueExpression();
        fe.setAttributes(new java.util.HashMap(1));
        fe.getAttributes().put("field-value", "toto");

        log.debug("FlowExpression ready");

        InFlowWorkItem wi = new InFlowWorkItem();
        wi.setAttributes(new StringMapAttribute());
        //wi.getAttributes().puts("toto", "toto-value");

        log.debug("Workitem ready");

        Object v = ValueUtils.determineValue(fe, wi);

        Assert.assertTrue
            ("Value is null", 
             v == null);
    }

}
