/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ControlSessionImpl.java 2905 2006-07-02 15:17:05Z jmettraux $
 */

//
// ControlSessionImpl.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.control.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;

import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.rmi.session.ClassedWorkSessionServer;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.ControlException;


/**
 * A rmi control session
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ControlSessionImpl.java 2905 2006-07-02 15:17:05Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ControlSessionImpl

    extends UnicastRemoteObject

    implements ControlSession, Service

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ControlSessionImpl.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private java.util.Map serviceParams = null;

    private Subject subject = null;

    //
    // CONSTRUCTORS

    public ControlSessionImpl ()
        throws RemoteException
    {
        super();
    }

    public void init
        (final String serviceName,
         final ApplicationContext applicationContext,
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        this.serviceName = serviceName;
        this.applicationContext = applicationContext;
        this.serviceParams = serviceParams;

        this.subject = 
            (Subject)serviceParams.get(ClassedWorkSessionServer.P_SUBJECT);

        if (this.subject == null) 
            log.warn("init() no subject passed.");
    }

    //
    // METHODS from Service

    public org.jdom.Element getStatus ()
    {
        return null;
            // giving no status info
    }

    public java.util.Map getParams ()
    {
        return this.serviceParams;
    }

    public ApplicationContext getContext ()
    {
        return this.applicationContext;
    }

    public String getName ()
    {
        return this.serviceName;
    }

    //
    // METHODS from ControlSession

    /**
     * Lists all the expressions currently in the expression pool of
     * the engine.
     */
    public java.util.List listExpressions ()
        throws ControlException, RemoteException
    {
        try
        {
            return (java.util.List)Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.ListAction
                    (this.applicationContext,
                     this.subject));
        }
        catch (final PrivilegedActionException pae)
        {
            log.warn
                ("listExpressions() failure", pae.getException());

            throw new ControlException
                ("failed to list expressions", pae.getException());
        }
    }

    /**
     * If an expression is frozen (it's usually a participant expression that
     * failed to dispatch), this expression will attempt to unfreeze it.
     */
    public void unfreezeExpression 
        (final FlowExpressionId freezableExpressionId)
    throws 
        ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.UnfreezeExpressionAction
                    (this.applicationContext,
                     this.subject,
                     freezableExpressionId));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("unfreezeExpression() failure", pae.getException());

            throw new ControlException
                ("failed to unfreeze expression", pae.getException());
        }
    }

    /*
    public void cancelFlow (final FlowExpressionId fei)
        throws ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.CancelFlowAction
                    (this.applicationContext,
                     this.subject,
                     fei));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("cancelFlow() failure", pae.getException());

            throw new ControlException
                ("failed to cancel flow", pae.getException());
        }
    }
    */

    /**
     * Cancels a complete flow.
     */
    public void cancelFlow (String workflowInstanceId)
        throws ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.CancelFlowAction
                    (this.applicationContext,
                     this.subject,
                     workflowInstanceId));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("cancelFlow() failure", pae.getException());

            throw new ControlException
                ("failed to cancel flow", pae.getException());
        }
    }

    public void cancelExpression (final FlowExpressionId fei)
        throws ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.CancelExpressionAction
                    (this.applicationContext,
                     this.subject,
                     fei));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("cancelExpression() failure", pae.getException());

            throw new ControlException
                ("failed to cancel expression", pae.getException());
        }
    }

    public void freezeFlow (final String workflowInstanceId)
        throws ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.FreezeFlowAction
                    (this.applicationContext,
                     this.subject,
                     workflowInstanceId));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("freezeFlow() failure", pae.getException());

            throw new ControlException
                ("failed to freeze flow", pae.getException());
        }
    }

    public void freezeExpression (final FlowExpressionId freezableExpressionId)
        throws ControlException, RemoteException
    {
        try
        {
            Subject.doAs
                (this.subject, 
                 new openwfe.org.engine.control.actions.FreezeExpressionAction
                    (this.applicationContext,
                     this.subject,
                     freezableExpressionId));
        }
        catch (PrivilegedActionException pae)
        {
            log.warn
                ("freezeExpression() failure", pae.getException());

            throw new ControlException
                ("failed to freeze expression", pae.getException());
        }
    }

    //
    // METHODS from WorkSession

    public void release ()
        throws RemoteException
    {
        // nothing to do for the moment
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
