/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CompositeFlowExpression.java 2718 2006-06-02 05:24:52Z jmettraux $
 */

//
// CompositeFlowExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;


/**
 * the template for an expression containing sub-expressions
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-02 07:24:52 +0200 (Fri, 02 Jun 2006) $
 * <br>$Id: CompositeFlowExpression.java 2718 2006-06-02 05:24:52Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface CompositeFlowExpression
{

    //
    // (BEAN METHODS)

    public java.util.List getChildren ();

    public void setChildren (java.util.List l);

    //
    // METHODS

    /**
     * Adds a child to the expression (as last child)
     */
    public void addChild (FlowExpressionId fei);

    /**
     * Adds a child to the expression (at a given position).
     * A position of -1 would mean, 'insert at the end'.
     */
    public void addChild (FlowExpressionId fei, int position);

    /**
     * Removes a child from this composite expression
     */
    public void removeChild (FlowExpressionId fei);

    /**
     * A droflo method, moves up a child up one position
     */
    public void moveUpChild (FlowExpressionId fei);

    /**
     * A droflo method, moves up a child down one position
     */
    public void moveDownChild (FlowExpressionId fei);

    /* *
     * Replaces this child with that one.
     * Returns true if the child was found in this composite flow exp
     * /
    public boolean replaceChild 
        (FlowExpressionId thisFei, FlowExpressionId thatFei);
     */

}
