/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ConcurrenceExpression.java 2901 2006-06-29 21:14:17Z jmettraux $
 */

//
// ConcurrenceExpression.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions;

import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.sync.SyncUtils;
import openwfe.org.engine.expressions.sync.SyncExpression;
import openwfe.org.engine.expressions.sync.SynchableExpression;


/**
 * The basic 'concurrence' expression : the expression that sends 
 * a copy of the workitem to each of its child quasi-simultaneously.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-29 23:14:17 +0200 (Thu, 29 Jun 2006) $
 * <br>$Id: ConcurrenceExpression.java 2901 2006-06-29 21:14:17Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ConcurrenceExpression

    //extends ConcurrentFlowExpression

    extends CleanCompositeFlowExpression

    implements SynchableExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ConcurrenceExpression.class.getName());

    //
    // CONSTANTS (definitions)

    //
    // FIELDS

    private SyncExpression syncExpression = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    //
    // METHODS from SynchableExpression

    public SyncExpression getSyncExpression () 
    { 
        return this.syncExpression; 
    }

    public void setSyncExpression (final SyncExpression se) 
    { 
        //log.debug("setSyncExpression() "+se.getClass());

        this.syncExpression = se;
    }

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi) 
        throws ApplyException
    {

        if (getChildren() == null || getChildren().size() < 1)
        {
            //log.debug
            //    ("apply() "+
            //     "No children to throw, replying to parent expression");

            applyToParent(wi);

            return;
        }

        //
        // determine sync expression

        //log.debug("apply() setting syncExpression");

        this.setSyncExpression
            (SyncUtils.determineSyncExpression(this, getChildren(), wi));

        //
        // run this concurrence stuff

        //synchronized (this)
        //{
        int i;

        for (i = 0; i < getChildren().size(); i++)
        {
            final FlowExpressionId child = 
                (FlowExpressionId)getChildren().get(i);
            
            getSyncExpression().addChild(child);
        }

        try
        {
            this.getSyncExpression().ready(this);
        }
        catch (final ReplyException re)
        {
            throw new ApplyException
                ("Failed to tag sync expression as 'ready'", re);
        }

        for (i = 0; i < getChildren().size(); i++)
        {
            final FlowExpressionId child = 
                (FlowExpressionId)getChildren().get(i);

            //getExpressionPool().apply(child, (InFlowWorkItem)wi.clone());
            applyChild(child, wi);
        }

        //synchronized (this)
        //{
        this.storeItself();
        //}
        //}
    }

    protected void applyChild 
        (final FlowExpressionId fei, final InFlowWorkItem wi)
    throws 
        ApplyException
    {
        final InFlowWorkItem ifwi = (InFlowWorkItem)wi.clone();

        //getExpressionPool().apply(fei, ifwi);

        (new Thread ()
         {
             public void run ()
             {
                 try
                 {
                     //getExpressionPool().apply(fei, ifwi);
                      
                     ConcurrenceExpression.this.syncExpression
                         .applyChild(ConcurrenceExpression.this, fei, ifwi);
                 }
                 catch (final Throwable t)
                 {
                     log.error("applyChild() failed to apply  "+fei, t);
                 }
             }
         }).start();
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        //synchronized (this) // first in first out
        //{
        //log.debug("reply()");

        getSyncExpression().reply(this, wi);

        //this.storeItself();
            // 
            // this is now done in the sync expression
        //}
    }

}
