/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MergeUtils.java 2668 2006-05-25 15:15:15Z jmettraux $
 */

//
// MergeUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.sync;

import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * This utility class currently holds only one method fro merging 
 * workitems : merge().
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: MergeUtils.java 2668 2006-05-25 15:15:15Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class MergeUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MergeUtils.class.getName());


    /**
     * The target will be overriden with the fields of the source, the
     * returned result will be a brand new workitem though.
     */
    public static InFlowWorkItem merge 
        (final InFlowWorkItem target, final InFlowWorkItem source)
    {
        return merge(false, target, source);
    }

    /**
     * The attributes of the source workitem will be added to the target
     * workitem and potentially overriden.
     */
    public static void mergeInPlace
        (final InFlowWorkItem target, final InFlowWorkItem source)
    {
        merge(true, target, source);
    }
    
    private static InFlowWorkItem merge 
        (final boolean inPlace, 
         InFlowWorkItem target, 
         final InFlowWorkItem source)
    {
        if (target == null)
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("merge() target is null, returning source  "+
                     source.getLastExpressionId());
            }

            return (InFlowWorkItem)source.clone();
        }

        //log.debug("merge() target is  "+target.getLastExpressionId());
        //log.debug("merge() source is  "+source.getLastExpressionId());
        //
        //log.debug("merge() target \n"+dumpWorkitem(target));
        //log.debug("merge() source \n"+dumpWorkitem(source));

        // clone target

        if ( ! inPlace)
            target = (InFlowWorkItem)target.clone();

        //
        // workitem fields

        final java.util.Iterator it = 
            source.getAttributes().keySet().iterator();
        while (it.hasNext())
        {
            final Attribute key = 
                (Attribute)((Attribute)it.next()).clone();

            final Attribute value = 
                (Attribute)source.getAttributes().get(key).clone();

            target.getAttributes().put(key, value);

            //if ( ! key.toString().equals("__definition__"))
            //{
            //    log.debug
            //        ("merge() put  '"+key.toString()+
            //         "' --> '"+value.toString()+"'");
            //}
        }

        //
        // workitem attributes
        
        /*
         * maybe some differientation between the two history tracks
         * would be good
         *
        target.getHistory().addAll(source.getHistory());
         */

        /*
         * way lighter...
         */
        target.setHistory(source.getHistory());

        //
        // ok

        //log.debug("merge() result \n"+dumpWorkitem(target));

        return target;
    }

    /*
    private static String dumpWorkitem (final InFlowWorkItem wi)
    {
        final StringBuffer sb = new StringBuffer();

        sb
            .append(">>> workitem from ")
            .append(wi.getLastExpressionId().toString())
            .append("\n");

        final java.util.Iterator it = wi.getAttributes().alphaStringIterator();
        while (it.hasNext())
        {
            final String key = (String)it.next();

            if (key.equals("__definition__")) continue;

            final String value = wi.getAttributes().get(key).toString();

            sb
                .append("  - '")
                .append(key)
                .append("' --> '")
                .append(value)
                .append("'\n");
        }

        sb.append("<<<");

        return sb.toString();
    }
    */

}
