/*
 * Copyright (c) 2005-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: IsExpression.java 2670 2006-05-26 19:06:15Z jmettraux $
 */

//
// IsExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.AtomicAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;


/**
 * is-null, is-list, is-atom, ...
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: IsExpression.java 2670 2006-05-26 19:06:15Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class IsExpression

    extends OneChildExpression

    implements WithChildren

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(IsExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        if (getChildExpressionId() == null)
            //
            // no child
        {
            log.debug("apply() no child.");

            final String s = lookupAttribute(A_VALUE, wi);

            if (s != null)
            {
                ValueUtils.setResult(wi, new StringAttribute(s));
                try
                {
                    reply(wi);
                }
                catch (final ReplyException e)
                {
                    throw new ApplyException
                        ("failure", e);
                }
                return;
            }

            applyToParent(wi);
            return;
        }

        //
        // one child

        getExpressionPool().apply(getChildExpressionId(), wi);
    }

    public void reply (final InFlowWorkItem wi) 
        throws ReplyException
    {
        final String expName = this.getId().getExpressionName();
        final Attribute a = ValueUtils.getResult(wi);

        if (log.isDebugEnabled())
        {
            log.debug("reply() a.class is "+a.getClass().getName());
            log.debug("reply() a       is "+a.toString());
        }

        final org.jdom.Content c = XemeUtils.toXemeResult(this, a);

        if (log.isDebugEnabled())
            log.debug("reply() c is >"+XmlUtils.xmlToString(c)+"<");

        boolean result = false;

        if (log.isDebugEnabled())
            log.debug("reply() expName is >"+expName+"<");

        if (expName.equals("is-null"))
            result = XemeUtils.isNull(c);
        else if (expName.equals("is-atom"))
            result = XemeUtils.isAtom(c);
        else if (expName.equals("is-list"))
            result = XemeUtils.isList(c);
        else if (expName.equals("is-empty"))
            result = XemeUtils.isEmpty(c);
        else
            log.warn("reply() unknown expression name '"+expName+"'");

        if (log.isDebugEnabled())
            log.debug("reply() result is "+result);

        ValueUtils.setBooleanResult(wi, result);

        replyToParent(wi);
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
