/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlFunctionMap.java 2694 2006-05-29 21:00:05Z jmettraux $
 */

//
// XmlFunctionMap.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.functions;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.functions.AbstractFunctionMap;
import openwfe.org.engine.expressions.FlowExpression;


/**
 * An implementation of FunctionMap that reads the name of the classes
 * containing functions in an XML files (usually etc/engine/function-map.xml).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlFunctionMap.java 2694 2006-05-29 21:00:05Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlFunctionMap

    extends AbstractFunctionMap

    implements XconfElementBuilder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlFunctionMap.class.getName());

    //
    // CONSTANTS & co

    /**
     * The paramater 'functionMapFile' tells this service where it can find
     * the function configuration file.
     * By default it's "etc/engine/function-map.xml".
     */
    public final static String P_FUNCTION_MAP_FILE
        = "functionMapFile";

    //
    // FIELDS

    private XconfBuilder builder = null;

    //
    // CONSTRUCTORS

    //
    // METHODS from XconfElementBuilder

    /**
     * Clears the function map. This method should and is only called by
     * the XconfBuilder helper class.
     */
    public void clearConfig ()
    {
        setClasses(new java.util.ArrayList(25));
        setFunctionMap(new java.util.HashMap(25));
    }

    /**
     * XconfBuilder calls this method when parsing a config file. It should
     * only be used by XconfBuilder.
     */
    public void parseElement 
        (final XconfBuilder builder, final org.jdom.Element elt)
    throws 
        ServiceException
    {
        final String className = elt.getTextTrim();

        try
        {
            final Class clazz = Class.forName(className);
            getClasses().add(clazz);

            log.info("added class '"+className+"' as source of functions");
        }
        catch (Throwable t)
        {
            log.warn
                ("parseElement() failed to add class '"+className+
                 "'. Skipped it.", t);
        }
    }

    //
    // METHODS from FunctionMap

    /**
     * This is the main method of a FunctionMap, given a functionName, a
     * workitem and an array of args.
     * Basic functions like "today()" do not care about args or the 
     * workitem.<br>
     * This version will check if there is a new version available of the
     * config files.
     */
    public String eval 
        (final String functionName, 
         final FlowExpression fe,
         final InFlowWorkItem wi, 
         final String[] args)
    {
        try
        {
            this.builder.refreshConfig();
        }
        catch (final ServiceException se)
        {
            log.warn
                ("eval() refreshConfig failed, "+
                 "check your functionMap service files", se);
        }

        return super.eval(functionName, fe, wi, args);
    }

    //
    // METHODS from AbstractFunctionMap

    /**
     * This method is called by init to parse the XML config files (and
     * any included file)
     */
    protected void buildMap () 
        throws ServiceException
    {
        String url = MapUtils.getAsString
            (getParams(), 
             P_FUNCTION_MAP_FILE,
             "etc/engine/function-map.xml");

        url = Utils.expandUrl
            (getContext().getApplicationDirectory(), url);

        this.builder = new XconfBuilder(url, this);
        this.builder.buildConfig();
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
