/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkItem.java 2717 2006-06-01 15:26:06Z jmettraux $
 */

//
// WorkItem.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.time.Time;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * The basic implementation of a workitem. It is implemented by both 
 * LaunchItem and InFlowWorkItem
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-06-01 17:26:06 +0200 (Thu, 01 Jun 2006) $
 * <br>$Id: WorkItem.java 2717 2006-06-01 15:26:06Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class WorkItem

    implements Cloneable, java.io.Serializable

{

    static final long serialVersionUID = -7773035923790384871L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WorkItem.class.getName());
    */

    //
    // FIELDS

    /*
     * When a workitem gets modified, the author of the change should take care
     * of setting this variable to the current datetime string value.
     */
    private String lastModified = null;

    /*
     * A workitem is mainly a map of attributes (often they are called
     * fields), so this StringMapAttribute holds all the attributes.
     * A StringMapAttribute is a map whose keys must be StringAttribute
     * and where values are attributes, so it's very convenient as a
     * payload carrier for workitems.
     */
    private StringMapAttribute attributes = new StringMapAttribute();

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * When a workitem gets modified, the author of the change should take care
     * of setting this variable to the current datetime string value.
     */
    public String getLastModified () { return this.lastModified; }

    /**
     * A workitem is mainly a map of attributes (often they are called
     * fields), so this StringMapAttribute holds all the attributes.
     * A StringMapAttribute is a map whose keys must be StringAttribute
     * and where values are attributes, so it's very convenient as a
     * payload carrier for workitems.
     */
    public StringMapAttribute getAttributes () { return this.attributes; }

    public void setLastModified (String isoDate) { this.lastModified = isoDate; }
    public void setAttributes (StringMapAttribute m) { this.attributes = m; }

    //
    // METHODS

    /**
     * A shortcut method for 
     * getAttributes().get(new StringAttribute(attributeName));
     */
    public Attribute getAttribute (final String attributeName)
    {
        if (this.attributes == null) return null;

        return this.attributes.get(attributeName);
    }

    /**
     * A shortcut method for
     * getAttributes().put(new StringAttribute(attributeName, attributeValue));
     * It will throw an AttributeException if there is not already
     * an attribute named as attributeName. See AddAttribute() if 
     * you really want to add a new attribute...
     */
    public void setAttribute 
        (final String attributeName, final Attribute attributeValue)
    throws 
        AttributeException
    {
        if (this.attributes == null) 
            this.attributes = new StringMapAttribute(1);

        if ( ! this.attributes.stringKeySet().contains(attributeName))
        {
            throw new AttributeException
                ("WorkItem doesn't contain any attribute named '"+
                 attributeName+"'");
        }

        this.attributes.put(attributeName, attributeValue);

        touch();
    }

    /**
     * Adds a brand new attribute, if the attribute with the same
     * name already exists, an instance of AttributeException will be
     * thrown.
     */
    public void addAttribute
        (final String attributeName, final Attribute attributeValue)
    throws 
        AttributeException
    {
        if (this.attributes == null) 
            this.attributes = new StringMapAttribute(1);

        if (this.attributes.stringKeySet().contains(attributeName))
        {
            throw new AttributeException
                ("WorkItem already contains an attribute named '"+
                 attributeName+"'");
        }

        this.attributes.put(attributeName, attributeValue);

        touch();
    }

    /**
     * Removes an attribute from the workitem.
     */
    public void removeAttribute (final String attributeName)
    {
        this.attributes.remove(attributeName);
        touch();
    }

    /**
     * Will return true if the workitem contains an attribute with a given
     * attributeName.
     */
    public boolean containsAttribute (String attributeName)
    {
        if (this.attributes == null) return false;

        return this.attributes.stringKeySet().contains(attributeName);
    }

    /**
     * Sets the 'lastModified' value to the current datetime string value.
     */
    public void touch ()
    {
        this.lastModified = Time.toIsoDate();
    }

}
