/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.auth;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.Map;
import openwfe.org.engine.control.auth.ControlPermissionCollection;
import org.apache.log4j.Logger;

public class ControlPermission
extends openwfe.org.auth.Permission {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$auth$ControlPermission == null ? (class$openwfe$org$engine$control$auth$ControlPermission = ControlPermission.class$("openwfe.org.engine.control.auth.ControlPermission")) : class$openwfe$org$engine$control$auth$ControlPermission).getName());
    public static final String P_RIGHTS = "rights";
    public static final String P_ACTIONS = "actions";
    private static final int NONE = 0;
    private static final int READ = 1;
    private static final int FREEZE = 2;
    private static final int CANCEL = 4;
    private static final int ALL = 7;
    private static final String S_READ = "read";
    private static final String S_FREEZE = "freeze";
    private static final String S_CANCEL = "cancel";
    private int mask = 0;
    private transient String action = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$auth$ControlPermission;

    public ControlPermission(Map map) {
        super(map);
        String string = (String)map.get(P_RIGHTS);
        if (string == null) {
            string = (String)map.get(P_ACTIONS);
        }
        this.mask = ControlPermission.getMask(string);
        this.action = null;
    }

    public static ControlPermission newControlPermission(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("name", string);
        hashMap.put(P_RIGHTS, string2);
        return new ControlPermission(hashMap);
    }

    public int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ControlPermission)) {
            return false;
        }
        ControlPermission controlPermission = (ControlPermission)((Object)object);
        return this.mask == controlPermission.mask;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof ControlPermission)) {
            return false;
        }
        ControlPermission controlPermission = (ControlPermission)((Object)permission);
        return (this.mask & controlPermission.mask) == controlPermission.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new ControlPermissionCollection();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ControlPermission name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\" actions=\"");
        if ((this.mask & 1) == 1) {
            stringBuffer.append('r');
        } else {
            stringBuffer.append('-');
        }
        if ((this.mask & 2) == 2) {
            stringBuffer.append('f');
        } else {
            stringBuffer.append('-');
        }
        if ((this.mask & 4) == 4) {
            stringBuffer.append('c');
        } else {
            stringBuffer.append('-');
        }
        stringBuffer.append("\" />");
        return stringBuffer.toString();
    }

    protected static String removeWildcard(String string) {
        if (string.length() < 1) {
            return ".";
        }
        if (!string.endsWith("*")) {
            return string + '!';
        }
        return string.substring(0, string.length() - 1);
    }

    public static boolean namesMatch(String string, String string2) {
        string = ControlPermission.removeWildcard(string);
        string2 = ControlPermission.removeWildcard(string2);
        return string2.startsWith(string);
    }

    public static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        String[] stringArray = string.toLowerCase().split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.equals(S_READ)) {
                n |= 1;
                continue;
            }
            if (string2.equals(S_FREEZE)) {
                n |= 2;
                continue;
            }
            if (!string2.equals(S_CANCEL)) continue;
            n |= 4;
        }
        return n;
    }

    public String getActions() {
        if (this.action == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if ((this.mask & 1) == 1) {
                stringBuffer.append(S_READ);
            }
            if ((this.mask & 2) == 2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(S_FREEZE);
            }
            if ((this.mask & 4) == 4) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(S_CANCEL);
            }
            this.action = stringBuffer.toString();
        }
        return this.action;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

