/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.rest;

import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.List;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import openwfe.org.rest.RestService;
import openwfe.org.rest.RmiBridgedRestSession;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class RestControlSession
extends RmiBridgedRestSession {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$rest$RestControlSession == null ? (class$openwfe$org$engine$control$rest$RestControlSession = RestControlSession.class$("openwfe.org.engine.control.rest.RestControlSession")) : class$openwfe$org$engine$control$rest$RestControlSession).getName());
    private ControlSession session = null;
    private XmlWorkItemCoder coder = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$rest$RestControlSession;

    public void init(RestService restService, Long l, String string, String string2) throws ServiceException {
        super.init(restService, l, string, string2);
        WorkItemCoderLoader workItemCoderLoader = Definitions.getWorkItemCoderLoader(this.getService().getContext());
        this.coder = (XmlWorkItemCoder)workItemCoderLoader.getXmlCoder();
        log.info((Object)"WorkItemCoder successfully located");
    }

    protected boolean authentify(String string, String string2) throws ServiceException {
        try {
            this.session = (ControlSession)this.getWorkSessionServer().login(string, string2);
        }
        catch (Exception exception) {
            throw new ServiceException("login failed", (Throwable)exception);
        }
        return true;
    }

    protected Element encode(FlowExpression flowExpression) {
        Element element = new Element("expression");
        if (flowExpression.getApplyTime() != null) {
            element.setAttribute("apply-time", flowExpression.getApplyTime());
        }
        if (flowExpression.getState() != null) {
            element.setAttribute("state", flowExpression.getState().getName());
            element.setAttribute("state-since", Time.toIsoDate((long)flowExpression.getState().getSince()));
        }
        element.addContent((Content)this.coder.encode(flowExpression.getId()));
        return element;
    }

    protected FlowExpressionId parseFei(SelectionKey selectionKey, String[] stringArray) throws Exception {
        return this.coder.decodeFlowExpressionId(RestControlSession.parseBody((SelectionKey)selectionKey, (String[])stringArray));
    }

    public void do_listexpressions(SelectionKey selectionKey, String[] stringArray) throws Exception {
        List list = this.session.listExpressions();
        Element element = new Element("expressions");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            element.addContent((Content)this.encode(flowExpression));
        }
        this.reply(selectionKey, element);
    }

    public void do_cancelexpression(SelectionKey selectionKey, String[] stringArray) throws Exception {
        this.session.cancelExpression(this.parseFei(selectionKey, stringArray));
        this.reply(selectionKey, new Element("ok"));
    }

    public void do_freezeexpression(SelectionKey selectionKey, String[] stringArray) throws Exception {
        this.session.freezeExpression(this.parseFei(selectionKey, stringArray));
        this.reply(selectionKey, new Element("ok"));
    }

    public void do_unfreezeexpression(SelectionKey selectionKey, String[] stringArray) throws Exception {
        this.session.unfreezeExpression(this.parseFei(selectionKey, stringArray));
        this.reply(selectionKey, new Element("ok"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

