/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.control.ControlException;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.control.actions.CancelExpressionAction;
import openwfe.org.engine.control.actions.CancelFlowAction;
import openwfe.org.engine.control.actions.FreezeExpressionAction;
import openwfe.org.engine.control.actions.FreezeFlowAction;
import openwfe.org.engine.control.actions.ListAction;
import openwfe.org.engine.control.actions.UnfreezeExpressionAction;
import openwfe.org.engine.expressions.FlowExpressionId;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ControlSessionImpl
extends UnicastRemoteObject
implements ControlSession,
Service {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$rmi$ControlSessionImpl == null ? (class$openwfe$org$engine$control$rmi$ControlSessionImpl = ControlSessionImpl.class$("openwfe.org.engine.control.rmi.ControlSessionImpl")) : class$openwfe$org$engine$control$rmi$ControlSessionImpl).getName());
    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private Map serviceParams = null;
    private Subject subject = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$rmi$ControlSessionImpl;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        this.serviceName = string;
        this.applicationContext = applicationContext;
        this.serviceParams = map;
        this.subject = (Subject)map.get("__subject__");
        if (this.subject == null) {
            log.warn((Object)"init() no subject passed.");
        }
    }

    public Element getStatus() {
        return null;
    }

    public Map getParams() {
        return this.serviceParams;
    }

    public ApplicationContext getContext() {
        return this.applicationContext;
    }

    public String getName() {
        return this.serviceName;
    }

    public List listExpressions() throws ControlException, RemoteException {
        try {
            return (List)Subject.doAs(this.subject, new ListAction(this.applicationContext, this.subject));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"listExpressions() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to list expressions", privilegedActionException.getException());
        }
    }

    public void unfreezeExpression(FlowExpressionId flowExpressionId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new UnfreezeExpressionAction(this.applicationContext, this.subject, flowExpressionId));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"unfreezeExpression() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to unfreeze expression", privilegedActionException.getException());
        }
    }

    public void cancelFlow(String string) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new CancelFlowAction(this.applicationContext, this.subject, string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"cancelFlow() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to cancel flow", privilegedActionException.getException());
        }
    }

    public void cancelExpression(FlowExpressionId flowExpressionId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new CancelExpressionAction(this.applicationContext, this.subject, flowExpressionId));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"cancelExpression() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to cancel expression", privilegedActionException.getException());
        }
    }

    public void freezeFlow(String string) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new FreezeFlowAction(this.applicationContext, this.subject, string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"freezeFlow() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to freeze flow", privilegedActionException.getException());
        }
    }

    public void freezeExpression(FlowExpressionId flowExpressionId) throws ControlException, RemoteException {
        try {
            Subject.doAs(this.subject, new FreezeExpressionAction(this.applicationContext, this.subject, flowExpressionId));
        }
        catch (PrivilegedActionException privilegedActionException) {
            log.warn((Object)"freezeExpression() failure", (Throwable)privilegedActionException.getException());
            throw new ControlException("failed to freeze expression", privilegedActionException.getException());
        }
    }

    public void release() throws RemoteException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

