/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.shell;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.Naming;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.control.ControlSession;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.rmi.session.WorkSessionServer;
import openwfe.org.shell.CmdHandler;

public class ControlShell {
    public static final String BANNER = "\n" + (class$openwfe$org$engine$control$shell$ControlShell == null ? (class$openwfe$org$engine$control$shell$ControlShell = ControlShell.class$("openwfe.org.engine.control.shell.ControlShell")) : class$openwfe$org$engine$control$shell$ControlShell).getName() + "\n$Revision: 2905 $ John Mettraux, Jay Lawrence\n";
    private String url;
    private ControlSession session;
    private String prompt;
    private String language = null;
    private BufferedReader reader;
    private List lastExpressionList = null;
    static final Comparator expressionComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            FlowExpressionId flowExpressionId = ((FlowExpression)object).getId();
            FlowExpressionId flowExpressionId2 = ((FlowExpression)object2).getId();
            return flowExpressionId.getWorkflowInstanceId().compareTo(flowExpressionId2.getWorkflowInstanceId());
        }
    };
    static /* synthetic */ Class class$openwfe$org$engine$control$shell$ControlShell;

    public ControlShell(String string, ControlSession controlSession, BufferedReader bufferedReader) {
        this.url = string;
        this.session = controlSession;
        this.prompt = string + "> ";
        this.reader = bufferedReader;
    }

    private String toString(FlowExpression flowExpression) {
        boolean bl = flowExpression.getApplyTime() == null;
        StringBuffer stringBuffer = new StringBuffer();
        if (flowExpression.getState() != null) {
            stringBuffer.append(flowExpression.getState().getIdentifier());
        } else {
            stringBuffer.append("-");
        }
        if (bl) {
            stringBuffer.append("u");
        } else {
            stringBuffer.append("-");
        }
        stringBuffer.append("  ");
        stringBuffer.append(flowExpression.getId().getWorkflowInstanceId());
        stringBuffer.append("  ");
        stringBuffer.append(flowExpression.getId().getWorkflowDefinitionName());
        stringBuffer.append(" ");
        stringBuffer.append(flowExpression.getId().getWorkflowDefinitionRevision());
        stringBuffer.append("  ");
        stringBuffer.append(flowExpression.getId().getExpressionName());
        stringBuffer.append(" ");
        stringBuffer.append(flowExpression.getId().getExpressionId());
        return stringBuffer.toString();
    }

    private void displayExpressionList(String string, List list) {
        System.out.println(string);
        Collections.sort(list, expressionComparator);
        this.lastExpressionList = list;
        if (list == null) {
            System.out.println(" X   no results");
            return;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FlowExpression flowExpression = (FlowExpression)iterator.next();
            System.out.println("    - " + n + "  " + this.toString(flowExpression));
            ++n;
        }
    }

    private FlowExpressionId getExpression(String string) {
        if (this.lastExpressionList == null) {
            throw new IllegalArgumentException("No exceptions were 'list'ed before");
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a number");
        }
        if (n < 0 || n - 1 > this.lastExpressionList.size()) {
            throw new IllegalArgumentException("No expression at index " + n);
        }
        return ((FlowExpression)this.lastExpressionList.get(n)).getId();
    }

    public void help_list() {
        System.out.println("list");
        System.out.println("  lists both frozen and unapplied expressions");
    }

    public Boolean do_list(String[] stringArray) {
        try {
            this.displayExpressionList("expressions :", this.session.listExpressions());
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public void help_unfreeze() {
        System.out.println("unfreezex <expression_id>");
        System.out.println("  defreeze an expression, the engine will immediately try to apply it");
    }

    public Boolean do_unfreeze(String[] stringArray) {
        if (stringArray.length < 1) {
            this.help_unfreeze();
            return Boolean.FALSE;
        }
        try {
            this.session.unfreezeExpression(this.getExpression(stringArray[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public void help_freeze() {
        System.out.println("freezex <expression_id>");
        System.out.println("  freezes an expression, the engine will immediately try to apply it");
    }

    public Boolean do_freeze(String[] stringArray) {
        if (stringArray.length < 1) {
            this.help_freeze();
            return Boolean.FALSE;
        }
        try {
            this.session.freezeExpression(this.getExpression(stringArray[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public void help_cancel() {
        System.out.println("cancel <expression_id>");
        System.out.println("  cancels an expression (and all its children)");
        System.out.println("  and replies to its parent expression.");
    }

    public Boolean do_cancel(String[] stringArray) {
        if (stringArray.length < 1) {
            this.help_cancel();
            return Boolean.FALSE;
        }
        try {
            this.session.cancelExpression(this.getExpression(stringArray[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public void help_cancelf() {
        System.out.println("cancelf <workflow_instance_id>");
        System.out.println("  cancels a whole process instance.");
    }

    public Boolean do_cancelf(String[] stringArray) {
        if (stringArray.length < 1) {
            this.help_cancelf();
            return Boolean.FALSE;
        }
        try {
            this.session.cancelFlow(stringArray[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return Boolean.FALSE;
    }

    public Boolean do_quit(String[] stringArray) {
        return CmdHandler.DO_EXIT;
    }

    public Boolean do_exit(String[] stringArray) {
        return CmdHandler.DO_EXIT;
    }

    public void run() {
        CmdHandler cmdHandler = new CmdHandler((Object)this);
        cmdHandler.commandLoop(this.prompt, this.reader);
        System.out.println("Bye.");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string;
        System.out.println(BANNER);
        if (stringArray.length > 0 && ((string = stringArray[0].trim().toLowerCase()).equals("-help") || string.equals("--help") || string.equals("-h") || string.equals("-?"))) {
            System.out.println("OpenWFE engine control client");
            System.out.println();
            System.out.println("Usage: " + (class$openwfe$org$engine$control$shell$ControlShell == null ? (class$openwfe$org$engine$control$shell$ControlShell = ControlShell.class$("openwfe.org.engine.control.shell.ControlShell")) : class$openwfe$org$engine$control$shell$ControlShell).getName() + " [<session server URL> [<username> [<password>]]");
            System.out.println();
            System.out.println("Default URL is rmi://localhost:7089/controlSessionServer");
            System.exit(0);
        }
        try {
            String string2;
            String string3;
            string = stringArray.length > 0 ? stringArray[0] : "rmi://localhost:7089/controlSessionServer";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (stringArray.length > 1) {
                string3 = stringArray[1];
            } else {
                System.out.print("username> ");
                string3 = bufferedReader.readLine();
            }
            if (stringArray.length > 2) {
                string2 = stringArray[2];
            } else {
                System.out.print("password> ");
                string2 = bufferedReader.readLine();
            }
            WorkSessionServer workSessionServer = (WorkSessionServer)Naming.lookup(string);
            ControlSession controlSession = (ControlSession)workSessionServer.login(string3, string2);
            new ControlShell(string, controlSession, bufferedReader).run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

