/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.dispatch;

import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.FatalDispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.WorkItemCoderLoader;
import org.apache.log4j.Logger;

public abstract class AbstractWorkItemDispatcher
extends AbstractService
implements WorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher == null ? (class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher = AbstractWorkItemDispatcher.class$("openwfe.org.engine.dispatch.AbstractWorkItemDispatcher")) : class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher).getName());
    public static final String P_WORKITEM_CODER = "workItemCoder";
    private String workItemCoderName = null;
    static /* synthetic */ Class class$openwfe$org$engine$dispatch$AbstractWorkItemDispatcher;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.workItemCoderName = MapUtils.getAsString((Map)this.getParams(), (String)P_WORKITEM_CODER);
        WorkItemCoderLoader workItemCoderLoader = Definitions.getWorkItemCoderLoader(this.getContext());
        WorkItemCoder workItemCoder = workItemCoderLoader.getCoder(this.workItemCoderName);
        if (workItemCoder == null) {
            workItemCoder = workItemCoderLoader.getDefaultCoder();
            log.info((Object)"using default coder");
        }
        this.workItemCoderName = workItemCoder.getName();
        log.info((Object)("Dispatcher '" + this.getName() + "' using coder '" + this.workItemCoderName + "'"));
    }

    public String getWorkItemCoderName() {
        return this.workItemCoderName;
    }

    protected WorkItemCoder instantiateEncoder() throws DispatchingException {
        WorkItemCoderLoader workItemCoderLoader = Definitions.getWorkItemCoderLoader(this.getContext());
        WorkItemCoder workItemCoder = workItemCoderLoader.getDefaultCoder();
        if (this.workItemCoderName != null) {
            workItemCoder = workItemCoderLoader.getCoder(this.workItemCoderName);
        }
        return workItemCoder;
    }

    protected Object handleReply(ListenerReply listenerReply) throws DispatchingException {
        if (listenerReply == null) {
            throw new DispatchingException("No reply from listener");
        }
        if (listenerReply instanceof FatalReply) {
            throw new FatalDispatchingException((FatalReply)listenerReply);
        }
        if (listenerReply instanceof OkReply) {
            log.debug((Object)"Listener replied 'ok'");
            return ((OkReply)listenerReply).getConsumerResult();
        }
        WarningReply warningReply = (WarningReply)listenerReply;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("listener warned :\n");
        stringBuffer.append(warningReply.getMessage());
        stringBuffer.append('\n');
        stringBuffer.append(warningReply.getExceptionMessage());
        stringBuffer.append('\n');
        stringBuffer.append(warningReply.getExceptionStackTrace());
        log.warn((Object)stringBuffer.toString());
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

