/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.dispatch;

import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.OpenWfeException;
import openwfe.org.ServiceException;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.listen.WorkItemConsumer;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.time.Time;
import org.jdom.Element;

public class LocalDispatcher
implements WorkItemDispatcher {
    public static final String P_CONSUMER = "consumer";
    protected String name = null;
    protected ApplicationContext applicationContext = null;
    protected Map params = null;
    protected String consumerName = null;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        this.name = string;
        this.applicationContext = applicationContext;
        this.params = map;
        this.consumerName = (String)this.params.get(P_CONSUMER);
        if (this.consumerName == null) {
            throw new ServiceException("Parameter 'consumer' is required for setting up service " + this.name);
        }
    }

    public Object dispatch(WorkItem object) throws DispatchingException {
        Object object2;
        if (object instanceof InFlowWorkItem) {
            object2 = (InFlowWorkItem)object;
            object2 = (InFlowWorkItem)((InFlowWorkItem)object2).clone();
            ((InFlowWorkItem)object2).setDispatchTime(Time.toIsoDate());
            object = object2;
        }
        object2 = (WorkItemConsumer)this.applicationContext.lookup(this.consumerName);
        try {
            return object2.use((WorkItem)object);
        }
        catch (OpenWfeException openWfeException) {
            throw new DispatchingException("local dispatching to consumer '" + this.consumerName + "' failed", openWfeException);
        }
    }

    public void stop() throws ServiceException {
    }

    public String getName() {
        return this.name;
    }

    public Element getStatus() {
        return new Element(this.getName());
    }
}

