/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.VariableMap;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.history.History;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.misc.Text;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlCoder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public abstract class AbstractFlowExpression
implements FlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$AbstractFlowExpression == null ? (class$openwfe$org$engine$expressions$AbstractFlowExpression = AbstractFlowExpression.class$("openwfe.org.engine.expressions.AbstractFlowExpression")) : class$openwfe$org$engine$expressions$AbstractFlowExpression).getName());
    private FlowExpressionId id = null;
    private FlowExpressionId parent = null;
    private String applyTime = null;
    private transient ApplicationContext applicationContext = null;
    private Map attributes = new HashMap(7);
    private FlowExpressionId envId = null;
    private ExpressionState state = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$AbstractFlowExpression;

    public FlowExpressionId getId() {
        return this.id;
    }

    public FlowExpressionId getParent() {
        return this.parent;
    }

    public String getApplyTime() {
        return this.applyTime;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public FlowExpressionId getEnvironmentId() {
        return this.envId;
    }

    public void setId(FlowExpressionId flowExpressionId) {
        this.id = flowExpressionId;
    }

    public void setParent(FlowExpressionId flowExpressionId) {
        this.parent = flowExpressionId;
    }

    public void setApplyTime(String string) {
        this.applyTime = string;
    }

    public void setAttributes(Map map) {
        this.attributes = map;
    }

    public void setEnvironmentId(FlowExpressionId flowExpressionId) {
        this.envId = flowExpressionId;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void launch(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.apply(inFlowWorkItem);
    }

    public Class getExpressionClass() {
        return this.getClass();
    }

    public ApplicationContext context() {
        return this.applicationContext;
    }

    protected static boolean referencesNoVariable(String string) {
        return string == null || string.indexOf("${") < 0;
    }

    public String lookupAttribute(String string, InFlowWorkItem inFlowWorkItem) {
        String string2 = (String)this.attributes.get(string);
        return this.substituteText(string2, inFlowWorkItem);
    }

    public String lookupAttribute(String string, InFlowWorkItem inFlowWorkItem, String string2) {
        String string3 = this.lookupAttribute(string, inFlowWorkItem);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public String substituteText(String string, InFlowWorkItem inFlowWorkItem) {
        if (AbstractFlowExpression.referencesNoVariable(string)) {
            return string;
        }
        VariableMap variableMap = new VariableMap(this, inFlowWorkItem);
        String string2 = Text.substitute((String)string, (Map)variableMap);
        return string2;
    }

    public void touchApplyTime() {
        this.setApplyTime(Time.toIsoDate());
    }

    public Object lookupVariable(String string) {
        if (this.getExpressionPool() == null) {
            return null;
        }
        return this.getExpressionPool().lookupVariable(this, string);
    }

    public void bindVariable(String string, Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("bindVariable() '" + string + "' -> '" + object + "'"));
            log.debug((Object)("bindVariable() for " + this.getClass().getName() + "  " + this.getId()));
        }
        if (this.getExpressionPool() == null) {
            return;
        }
        this.getExpressionPool().setVariable(this, string, object);
    }

    public void initWorkflowInstanceId(String string) {
        if (this.parent != null) {
            this.parent.setWorkflowInstanceId(string);
        }
        this.id.setWorkflowInstanceId(string);
    }

    public String getAttributeValue(String string) {
        return (String)this.attributes.get(string);
    }

    public void tag(InFlowWorkItem inFlowWorkItem) {
        if (inFlowWorkItem == null) {
            log.warn((Object)("tag() wi is null ??? for " + this.getId()));
            return;
        }
        inFlowWorkItem.setId(this.getId());
    }

    public void storeItself() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("storeItself() invoked for " + this.getId() + " (" + this.getClass().getName() + ")"));
            log.debug((Object)("storeItself() parent is " + this.getParent()));
        }
        if (this.applicationContext == null || this.getExpressionPool() == null) {
            log.warn((Object)"storeItself() no applicationContext or expressionPool, cannot store.");
            return;
        }
        try {
            this.getExpressionPool().update(this);
        }
        catch (PoolException poolException) {
            log.warn((Object)"storeItself() failure", (Throwable)((Object)poolException));
        }
    }

    public ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool(this.applicationContext);
    }

    public ExpressionMap getExpressionMap() {
        return Definitions.getExpressionMap(this.applicationContext);
    }

    public ParticipantMap getParticipantMap() {
        return Definitions.getParticipantMap(this.applicationContext);
    }

    public Launcher getLauncher() {
        return Definitions.getLauncher(this.applicationContext);
    }

    private History getHistory() {
        return Definitions.getHistory(this.applicationContext);
    }

    public void historyLog(WorkItem workItem, String string, String string2, String string3) {
        History history = this.getHistory();
        if (history == null) {
            return;
        }
        history.log(this.getId(), workItem, string, string2, string3);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        return null;
    }

    public void replyToParent(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.tag(inFlowWorkItem);
        this.getExpressionPool().replyToParent(this, inFlowWorkItem);
    }

    public void applyToParent(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        try {
            this.replyToParent(inFlowWorkItem);
        }
        catch (ReplyException replyException) {
            throw new ApplyException("replyToParent() failed", (Throwable)((Object)replyException));
        }
    }

    public long getTimeSinceApplied() {
        try {
            return System.currentTimeMillis() - Time.fromIsoDate((String)this.applyTime);
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return object.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    public Object clone() {
        AbstractFlowExpression abstractFlowExpression = (AbstractFlowExpression)ReflectionUtils.newInstance((Object)this);
        abstractFlowExpression.setId(this.getId().copy());
        if (this.getEnvironmentId() != null) {
            abstractFlowExpression.setEnvironmentId(this.getEnvironmentId().copy());
        }
        if (this.getParent() != null) {
            abstractFlowExpression.setParent(this.getParent().copy());
        }
        abstractFlowExpression.applicationContext = this.context();
        abstractFlowExpression.setAttributes(Utils.copyHashMap((Map)this.getAttributes()));
        return abstractFlowExpression;
    }

    public void init(ApplicationContext applicationContext, FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, FlowExpressionId flowExpressionId3, RawExpression rawExpression, Object object, InFlowWorkItem inFlowWorkItem) throws BuildException {
        this.setApplicationContext(applicationContext);
        this.setId(flowExpressionId3);
        this.setParent(flowExpressionId2);
        this.setEnvironmentId(flowExpressionId);
        this.setAttributes(this.getLauncher().fetchAttributes(this, object));
    }

    public ExpressionState getState() {
        return this.state;
    }

    public void setState(ExpressionState expressionState) {
        this.state = expressionState;
    }

    public Environment fetchEnvironment() {
        return (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
    }

    public Element dump() {
        Element element = new Element("expression");
        element.setAttribute("class", this.getClass().getName());
        element.setAttribute("id", this.getId().toString());
        return element;
    }

    public void debugDump() {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("debugDump()  ").append(this.getClass().getName()).append("\n").append("   ").append(this.getId().toString()).append("\n").append("   attributes :\n");
        Iterator iterator = this.getAttributes().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getAttributes().get(string).toString();
            stringBuffer.append("     - '").append(string).append("' -->  >").append(string2).append("<\n");
        }
        log.debug((Object)stringBuffer.toString());
    }

    public void xmlDebugDump(String string) {
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            log.debug((Object)(string + "()\n" + XmlCoder.encodeToString((Object)this, null)));
        }
        catch (Throwable throwable) {
            log.debug((Object)(string + "() failure in xmlDebugDump()"), throwable);
        }
    }

    public static List deepCopy(List list) {
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((FlowExpressionId)iterator.next()).clone());
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

