/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BooleanExpression;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;

public abstract class BooleanCombinationExpression
extends CleanCompositeFlowExpression
implements BooleanExpression {
    private int childCount = 0;
    private List booleanValues = new ArrayList(10);

    public int getChildCount() {
        return this.childCount;
    }

    public List getBooleanValues() {
        return this.booleanValues;
    }

    public void setChildCount(int n) {
        this.childCount = n;
    }

    public void setBooleanValues(List list) {
        this.booleanValues = list;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.childCount = this.getChildren().size();
        this.storeItself();
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            FlowExpressionId flowExpressionId = (FlowExpressionId)iterator.next();
            this.getExpressionPool().apply(flowExpressionId, inFlowWorkItem);
        }
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.getBooleanValues().add(new Boolean(ValueUtils.lookupBooleanResult(inFlowWorkItem)));
        --this.childCount;
        if (this.childCount > 0) {
            this.storeItself();
            return;
        }
        ValueUtils.setBooleanResult(inFlowWorkItem, this.combineValues());
        this.replyToParent(inFlowWorkItem);
    }

    public abstract Boolean combineValues();
}

