/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.IfExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;

public class CaseExpression
extends IfExpression {
    private int currentId = -1;

    public int getCurrentId() {
        return this.currentId;
    }

    public void setCurrentId(int n) {
        this.currentId = n;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.applyToParent(inFlowWorkItem);
            return;
        }
        this.setCurrentId(0);
        this.storeItself();
        this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(this.getCurrentId()), inFlowWorkItem);
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (this.isConditionTreated()) {
            this.replyToParent(inFlowWorkItem);
            return;
        }
        if (this.getCurrentId() + 1 >= this.getChildren().size()) {
            this.replyToParent(inFlowWorkItem);
            return;
        }
        boolean bl = ValueUtils.lookupBooleanResult(inFlowWorkItem);
        if (bl) {
            this.setConditionTreated(true);
            this.setCurrentId(this.getCurrentId() + 1);
        } else {
            this.removeBranch(this.getCurrentId() + 1);
            if (this.getCurrentId() + 2 >= this.getChildren().size()) {
                this.replyToParent(inFlowWorkItem);
                return;
            }
            this.setCurrentId(this.getCurrentId() + 2);
        }
        this.storeItself();
        try {
            this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(this.getCurrentId()), inFlowWorkItem);
        }
        catch (ApplyException applyException) {
            throw new ReplyException("Failed to apply child expression at index " + this.getCurrentId(), (Throwable)((Object)applyException));
        }
    }

    protected void removeRemainingBranches() {
        for (int i = this.getCurrentId() + 1; i < this.getChildren().size(); ++i) {
            this.removeBranch(i);
        }
    }

    public void replyToParent(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.removeRemainingBranches();
        super.replyToParent(inFlowWorkItem);
    }
}

