/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class ChildrenTracker {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ChildrenTracker == null ? (class$openwfe$org$engine$expressions$ChildrenTracker = ChildrenTracker.class$("openwfe.org.engine.expressions.ChildrenTracker")) : class$openwfe$org$engine$expressions$ChildrenTracker).getName());
    private String[] childrenToMap = null;
    private String remainingContent = null;
    private InFlowWorkItem workitem = null;
    private Element xmlContent = null;
    private int position = -1;
    private Map results = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ChildrenTracker;

    public void init(String string, String[] stringArray, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.remainingContent = string;
        this.childrenToMap = stringArray;
        this.workitem = (InFlowWorkItem)inFlowWorkItem.clone();
        try {
            this.initializeXmlContent(true);
        }
        catch (Exception exception) {
            log.warn((Object)("failed to parse children out of \n" + this.remainingContent), (Throwable)exception);
            throw new ApplyException("failed to parse children", exception);
        }
        this.position = 0;
        this.results = new HashMap();
    }

    protected void initializeXmlContent(boolean bl) throws Exception {
        if (bl || this.xmlContent == null) {
            this.xmlContent = XmlUtils.extractXmlElement((String)this.remainingContent);
            if (this.xmlContent == null) {
                return;
            }
            this.xmlContent = ChildrenTracker.cleanElement(this.xmlContent);
            this.remainingContent = XmlUtils.xmlToString((Content)this.xmlContent);
        }
    }

    public String[] getChildrenToMap() {
        return this.childrenToMap;
    }

    public void setChildrenToMap(String[] stringArray) {
        this.childrenToMap = stringArray;
    }

    public String getRemainingContent() {
        return this.remainingContent;
    }

    public void setRemainingContent(String string) {
        this.remainingContent = string;
    }

    public InFlowWorkItem getWorkitem() {
        return this.workitem;
    }

    public void setWorkitem(InFlowWorkItem inFlowWorkItem) {
        this.workitem = inFlowWorkItem;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public Map getResults() {
        return this.results;
    }

    public void setResults(Map map) {
        this.results = map;
    }

    public boolean hasNext() {
        return this.position < this.childrenToMap.length;
    }

    public void applyNext(FlowExpression flowExpression) throws ReplyException {
        InFlowWorkItem inFlowWorkItem = (InFlowWorkItem)this.workitem.clone();
        Content content = this.fetchFirstChild();
        if (content == null) {
            ValueUtils.setResult(inFlowWorkItem, "");
            flowExpression.reply(inFlowWorkItem);
            return;
        }
        try {
            Launcher launcher = Definitions.getLauncher(flowExpression.context());
            RawExpression rawExpression = launcher.eval(flowExpression, content, inFlowWorkItem);
            flowExpression.storeItself();
            rawExpression.apply(inFlowWorkItem);
        }
        catch (Throwable throwable) {
            throw new ReplyException("failed to apply next [nested] child", throwable);
        }
    }

    public void reply(InFlowWorkItem inFlowWorkItem) {
        String string = this.childrenToMap[this.position];
        Attribute attribute = ValueUtils.getResult(inFlowWorkItem);
        this.results.put(string, attribute);
        ++this.position;
    }

    private Content fetchFirstChild() throws ReplyException {
        try {
            this.initializeXmlContent(false);
        }
        catch (Exception exception) {
            throw new ReplyException("failed to prepare xml content", exception);
        }
        if (this.xmlContent == null || this.xmlContent.getContent().size() < 1) {
            return null;
        }
        Content content = this.xmlContent.removeContent(0);
        this.remainingContent = XmlUtils.toString((Content)this.xmlContent);
        return content;
    }

    private static Element cleanElement(Element element) {
        Element element2 = new Element(element.getName());
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            if (content instanceof Text && ((Text)content).getTextTrim().length() < 1) continue;
            element2.addContent((Content)content.clone());
        }
        return element2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

