/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BooleanExpression;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;

public abstract class ComparisonExpression
extends ZeroChildExpression
implements BooleanExpression {
    public static final String EQUALS = "equals";
    public static final String OTHER_PREFIX = "other-";
    public static final String TYPE = "type";

    protected abstract Boolean computeResult(Integer var1, InFlowWorkItem var2);

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        Integer n = this.compareValues(inFlowWorkItem);
        ValueUtils.setBooleanResult(inFlowWorkItem, this.computeResult(n, inFlowWorkItem));
        this.applyToParent(inFlowWorkItem);
    }

    public boolean orEquals(InFlowWorkItem inFlowWorkItem) {
        String string = this.lookupAttribute(EQUALS, inFlowWorkItem);
        return "true".equalsIgnoreCase(string) || "ok".equalsIgnoreCase(string);
    }

    protected Integer compareValues(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        Object object = null;
        Object object2 = null;
        try {
            object = this.determineValue(inFlowWorkItem);
            object2 = this.determineOtherValue(inFlowWorkItem);
        }
        catch (ApplyException applyException) {
            return null;
        }
        if (object == null && object2 == null) {
            return new Integer(0);
        }
        if (object == null || object2 == null) {
            if (object == null) {
                return new Integer(-1);
            }
            return new Integer(1);
        }
        return new Integer(Utils.compareValues((Object)object, (Object)object2));
    }

    protected Object determineValue(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        try {
            return ValueUtils.determineValue(this, inFlowWorkItem);
        }
        catch (ValueException valueException) {
            throw new ApplyException("Failed to determine value for comparison", (Throwable)((Object)valueException));
        }
    }

    protected Object determineOtherValue(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        try {
            return ValueUtils.determineValue(OTHER_PREFIX, this, inFlowWorkItem);
        }
        catch (ValueException valueException) {
            throw new ApplyException("Failed to determine other value for comparison", (Throwable)((Object)valueException));
        }
    }
}

