/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.ExpressionToUnbind;
import openwfe.org.engine.expressions.OneRawChildExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import org.apache.log4j.Logger;

public class CronExpression
extends OneRawChildExpression
implements Schedulable,
ExpressionToUnbind {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$CronExpression == null ? (class$openwfe$org$engine$expressions$CronExpression = CronExpression.class$("openwfe.org.engine.expressions.CronExpression")) : class$openwfe$org$engine$expressions$CronExpression).getName());
    public static final String A_TAB = "tab";
    public static final String A_LEVEL = "level";
    public static final String A_NAME = "name";
    private static final String V_CRON = "__cron__";
    public static final String EVT_CRON = "-cro";
    private String tab = null;
    private String name = null;
    private String level = null;
    private Long cronId = null;
    private InFlowWorkItem appliedItem = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$CronExpression;

    public String getTab() {
        return this.tab;
    }

    public String getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public Long getCronId() {
        return this.cronId;
    }

    public InFlowWorkItem getAppliedItem() {
        return this.appliedItem;
    }

    public void setTab(String string) {
        this.tab = string;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setCronId(Long l) {
        this.cronId = l;
    }

    public void setAppliedItem(InFlowWorkItem inFlowWorkItem) {
        this.appliedItem = inFlowWorkItem;
    }

    public void trigger(Object[] objectArray) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("trigger() cron.id is  " + this.getId()));
                log.debug((Object)("trigger() cron.env is  " + this.getEnvironmentId()));
            }
            if (this.appliedItem == null) {
                return;
            }
            RawExpression rawExpression = (RawExpression)this.getRawChild().clone();
            rawExpression.getId().setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
            rawExpression.setEnvironmentId(this.getEnvironmentId());
            this.getExpressionPool().add(rawExpression);
            this.historyLog(this.appliedItem, EVT_CRON, null, "triggered");
            if (log.isDebugEnabled()) {
                log.debug((Object)("trigger() child is  " + rawExpression.getId()));
            }
            this.getLauncher().launchSub(this.appliedItem, null, rawExpression.getId(), new HashMap(0), true);
        }
        catch (Throwable throwable) {
            log.warn((Object)"trigger() problem", throwable);
        }
    }

    public Long reschedule(Scheduler scheduler) {
        return scheduler.schedule(this.tab, (Schedulable)this, new Object[0]);
    }

    public void unbind() throws PoolException {
        if (this.cronId == null) {
            return;
        }
        this.getExpressionPool().getScheduler().unschedule(this.cronId);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        try {
            this.unbind();
        }
        catch (Throwable throwable) {
            log.warn((Object)"cancel() minor trouble upon unscheduling", throwable);
        }
        return super.cancel();
    }

    private void determineNameAndLevel(InFlowWorkItem inFlowWorkItem) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.lookupAttribute(A_LEVEL, inFlowWorkItem);
        String string2 = this.lookupAttribute(A_NAME, inFlowWorkItem);
        if (string != null) {
            for (int i = 0; i < string.length() && stringBuffer.length() < 2 && string.charAt(i) == '/'; ++i) {
                stringBuffer.append('/');
            }
        } else if (string2 != null) {
            if (string2.startsWith("//")) {
                stringBuffer.append("//");
            } else if (string2.startsWith("/")) {
                stringBuffer.append("/");
            }
        }
        this.name = this.removeSlashes(string2);
        this.level = stringBuffer.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("determineNameAndLevel() '" + this.name + "' '" + this.level + "'"));
        }
    }

    private String removeSlashes(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return this.removeSlashes(string.substring(1));
        }
        return string;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.getChildExpressionId() == null) {
            return;
        }
        this.fetchRawChild();
        this.getExpressionPool().removeExpression(this.getChildExpressionId());
        this.appliedItem = (InFlowWorkItem)inFlowWorkItem.clone();
        this.tab = this.lookupAttribute(A_TAB, inFlowWorkItem);
        if (this.tab == null) {
            throw new ApplyException("Missing attribute 'tab'");
        }
        this.cronId = this.reschedule(this.getExpressionPool().getScheduler());
        this.determineNameAndLevel(inFlowWorkItem);
        Environment environment = null;
        if (this.level.equals("")) {
            environment = this.fetchEnvironment();
        } else if (this.level.equals("/")) {
            environment = this.getExpressionPool().fetchRootEnvironment(this);
        } else if (this.level.equals("//")) {
            environment = this.getExpressionPool().fetchEngineEnvironment();
        }
        this.getRawChild().setEnvironmentId(environment.getId());
        String string = null;
        string = this.name == null ? this.level + V_CRON + this.cronId.toString() : this.level + V_CRON + this.name;
        Object object = this.lookupVariable(string);
        if (object != null && object instanceof CronExpression) {
            CronExpression cronExpression = (CronExpression)object;
            this.getExpressionPool().getScheduler().unschedule(cronExpression.getCronId());
        }
        this.bindVariable(string, this);
        this.applyToParent(inFlowWorkItem);
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

