/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class CursorExpression
extends CleanCompositeFlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$CursorExpression == null ? (class$openwfe$org$engine$expressions$CursorExpression = CursorExpression.class$("openwfe.org.engine.expressions.CursorExpression")) : class$openwfe$org$engine$expressions$CursorExpression).getName());
    public static final String F_COMMAND = "__cursor_command__";
    public static final String A_COMMAND_FIELD = "command-field";
    public static final String C_BACK = "back";
    public static final String C_SKIP = "skip";
    public static final String C_BREAK = "break";
    public static final String C_CANCEL = "cancel";
    public static final String C_REWIND = "rewind";
    public static final String C_CONTINUE = "continue";
    public static final String A_DISALLOW = "disallow";
    private int currentId = -1;
    private FlowExpressionId currentFei = null;
    private String cursorCommandField = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$CursorExpression;

    public int getCurrentId() {
        return this.currentId;
    }

    public FlowExpressionId getCurrentFei() {
        return this.currentFei;
    }

    public void setCurrentId(int n) {
        this.currentId = n;
    }

    public void setCurrentFei(FlowExpressionId flowExpressionId) {
        this.currentFei = flowExpressionId;
    }

    public String getCursorCommandField() {
        return this.cursorCommandField;
    }

    public void setCursorCommandField(String string) {
        this.cursorCommandField = string;
    }

    private List lookupDisallow(InFlowWorkItem inFlowWorkItem) {
        String string = this.lookupAttribute(A_DISALLOW, inFlowWorkItem);
        if (string == null) {
            return new ArrayList(0);
        }
        String[] stringArray = string.split(", *");
        return Arrays.asList(stringArray);
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        String string;
        this.cursorCommandField = this.lookupAttribute(A_COMMAND_FIELD, inFlowWorkItem, F_COMMAND);
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() command field is >" + this.cursorCommandField + "<"));
        }
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            if (this.isLoop()) {
                log.warn((Object)"apply() loop with no children !!!");
                throw new ApplyException("loop with no children !");
            }
            this.applyToParent(inFlowWorkItem);
            return;
        }
        List list = this.lookupDisallow(inFlowWorkItem);
        if (list.contains(string = (string = inFlowWorkItem.getAttributes().sget(this.cursorCommandField)) == null ? "" : string.trim())) {
            string = "";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() sCommand' is >" + string + "<"));
        }
        if (string.equals(C_BREAK) || string.equals(C_CANCEL)) {
            this.applyToParent(inFlowWorkItem);
            return;
        }
        this.currentId = string.equals(C_REWIND) || string.equals(C_CONTINUE) ? 0 : (string.startsWith(C_BACK) || string.startsWith(C_SKIP) ? (this.currentId += this.extractStep(string)) : ++this.currentId);
        if (this.currentId < 0) {
            this.currentId = 0;
        }
        if (this.currentId >= this.getChildren().size()) {
            if (this.isLoop()) {
                this.currentId = 0;
            } else {
                this.applyToParent(inFlowWorkItem);
                return;
            }
        }
        inFlowWorkItem.getAttributes().puts(this.cursorCommandField, "");
        FlowExpressionId flowExpressionId = null;
        this.storeItself();
        flowExpressionId = (FlowExpressionId)this.getChildren().get(this.currentId);
        try {
            this.currentFei = this.getLauncher().launchSub(inFlowWorkItem, this.getId(), flowExpressionId, null, true);
            this.storeItself();
        }
        catch (LaunchException launchException) {
            log.warn((Object)("apply() next expression failed .... " + flowExpressionId.toString()), (Throwable)((Object)launchException));
        }
    }

    private int extractStep(String string) {
        int n;
        block5: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("extractStep() extract step from '" + string + "'"));
            }
            String[] stringArray = string.split("\\s+");
            n = 1;
            if (stringArray.length > 1) {
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Throwable throwable) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)("extractStep() cannot determine step in '" + string + "'"), throwable);
                }
            }
        }
        if (string.startsWith(C_BACK)) {
            n = -n;
        }
        return n;
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        try {
            this.apply(inFlowWorkItem);
        }
        catch (ApplyException applyException) {
            throw new ReplyException("reply failure", (Throwable)((Object)applyException));
        }
    }

    public void applyToParent(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        inFlowWorkItem.getAttributes().puts(this.cursorCommandField, "");
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            FlowExpressionId flowExpressionId = (FlowExpressionId)iterator.next();
            this.getExpressionPool().removeExpression(flowExpressionId);
        }
        super.applyToParent(inFlowWorkItem);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        InFlowWorkItem inFlowWorkItem = this.getExpressionPool().childCancel(this.currentFei);
        super.cancel();
        return inFlowWorkItem;
    }

    public boolean isLoop() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

