/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expressions.AbstractFlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.DefinitionExpression;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class DefineExpression
extends CleanCompositeFlowExpression
implements DefinitionExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$DefineExpression == null ? (class$openwfe$org$engine$expressions$DefineExpression = DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression")) : class$openwfe$org$engine$expressions$DefineExpression).getName());
    public static final String A_MAP_CHILDREN = "map-children";
    static /* synthetic */ Class class$openwfe$org$engine$expressions$DefineExpression;

    public Object eval(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("eval() name=\"" + this.lookupAttribute("name", inFlowWorkItem) + "\""));
        }
        String string = (String)this.getAttributes().get(A_MAP_CHILDREN);
        if (log.isDebugEnabled()) {
            log.debug((Object)("eval() sChildrenToMap >" + string + "<"));
        }
        AbstractFlowExpression abstractFlowExpression = null;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            FlowExpressionId flowExpressionId = (FlowExpressionId)iterator.next();
            RawExpression rawExpression = (RawExpression)this.getExpressionPool().fetch(flowExpressionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("eval() child is " + flowExpressionId));
            }
            if (!rawExpression.isDefinition()) {
                if (abstractFlowExpression != null) continue;
                abstractFlowExpression = rawExpression;
                abstractFlowExpression.getAttributes().put(A_MAP_CHILDREN, string);
                continue;
            }
            try {
                DefineExpression.define(this, rawExpression, inFlowWorkItem);
            }
            catch (BuildException buildException) {
                throw new ApplyException("Failed to bind definition", (Throwable)((Object)buildException));
            }
        }
        if (abstractFlowExpression == null) {
            throw new ApplyException("No body for definition " + this.getId());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("eval() body is " + abstractFlowExpression.getId()));
        }
        return abstractFlowExpression.getId();
    }

    public static FlowExpressionId define(FlowExpression flowExpression, RawExpression rawExpression, InFlowWorkItem inFlowWorkItem) throws BuildException, ApplyException {
        String string = rawExpression.getDefinitionName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("define() name >" + string + "<"));
        }
        Object object = null;
        if (string != null && string.startsWith("//") && (class$openwfe$org$engine$expressions$DefineExpression == null ? (class$openwfe$org$engine$expressions$DefineExpression = DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression")) : class$openwfe$org$engine$expressions$DefineExpression).isAssignableFrom(rawExpression.getExpressionClass())) {
            object = rawExpression.clone();
        } else {
            DefinitionExpression definitionExpression = (DefinitionExpression)((Object)rawExpression.resolveExpression(inFlowWorkItem));
            object = definitionExpression.eval(inFlowWorkItem);
        }
        flowExpression.getExpressionPool().removeExpression(rawExpression.getId());
        if (string != null && object != null) {
            flowExpression.bindVariable(string, object);
        } else {
            if (string == null && object instanceof FlowExpressionId) {
                return (FlowExpressionId)object;
            }
            log.warn((Object)("define() missing name or ref for definition at  " + flowExpression.getId()));
        }
        return null;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        log.debug((Object)"apply()");
        FlowExpression flowExpression = this.getExpressionPool().fetch(inFlowWorkItem.getLastExpressionId());
        String string = this.lookupAttribute("name", inFlowWorkItem);
        Object object = this.eval(inFlowWorkItem);
        if (string == null) {
            ValueUtils.setResult(inFlowWorkItem, object);
        } else {
            flowExpression.bindVariable(string, object);
        }
        this.applyToParent(inFlowWorkItem);
    }

    public void launch(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("launch() name=\"" + this.lookupAttribute("name", inFlowWorkItem) + "\""));
        }
        FlowExpressionId flowExpressionId = (FlowExpressionId)this.eval(inFlowWorkItem);
        this.setChildren(new ArrayList(1));
        this.getChildren().add(flowExpressionId);
        String string = "launching";
        if (this.getParent() != null) {
            string = "launching sub";
        }
        this.historyLog(inFlowWorkItem, "+STA", null, string);
        inFlowWorkItem.addHistoryItem(this.getId(), this.getClass().getName(), string);
        this.getExpressionPool().apply(flowExpressionId, inFlowWorkItem);
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        this.historyLog(inFlowWorkItem, "+END", null, "replying");
        if (this.getParent() != null) {
            this.replyToParent(inFlowWorkItem);
        } else {
            this.getExpressionPool().removeExpression(this);
        }
    }

    public void init(ApplicationContext applicationContext, FlowExpressionId flowExpressionId, FlowExpressionId flowExpressionId2, FlowExpressionId flowExpressionId3, RawExpression rawExpression, Object object, InFlowWorkItem inFlowWorkItem) throws BuildException {
        super.init(applicationContext, flowExpressionId, flowExpressionId2, flowExpressionId3, rawExpression, object, inFlowWorkItem);
        if (this.getChildren() == null) {
            return;
        }
        int n = 0;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FlowExpressionId)) continue;
            FlowExpressionId flowExpressionId4 = (FlowExpressionId)e;
            Class clazz = this.getExpressionMap().getClass(flowExpressionId4.getExpressionName());
            if (clazz == null) {
                log.warn((Object)("init() " + flowExpressionId3.getExpressionName() + " unknown expression '" + flowExpressionId4.getExpressionName() + "'"));
                continue;
            }
            if (!(class$openwfe$org$engine$expressions$DefineExpression == null ? DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression") : class$openwfe$org$engine$expressions$DefineExpression).isAssignableFrom(clazz)) {
                ++n;
            }
            if (n <= 1) continue;
            log.warn((Object)("init() " + flowExpressionId3.getExpressionName() + " with more than one body"));
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

