/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.ExpressionToUnbind;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class Environment
extends ZeroChildExpression
implements ExpressionToUnbind {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$Environment == null ? (class$openwfe$org$engine$expressions$Environment = Environment.class$("openwfe.org.engine.expressions.Environment")) : class$openwfe$org$engine$expressions$Environment).getName());
    public static final String EXPRESSION_NAME = "__env__";
    private Map variables = new LinkedHashMap();
    private List cachedKeySet = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$Environment;

    public static Environment generateEnvironment(FlowExpression flowExpression) throws BuildException, PoolException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateEnvironment() for " + flowExpression.getId() + "  (" + flowExpression.getClass().getName() + ")"));
        }
        Environment environment = new Environment();
        FlowExpressionId flowExpressionId = flowExpression.getId().copy();
        flowExpressionId.setExpressionId(flowExpressionId.getExpressionId() + "e");
        flowExpressionId.setExpressionName(EXPRESSION_NAME);
        environment.setApplicationContext(flowExpression.context());
        environment.setEnvironmentId(flowExpression.getEnvironmentId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateEnvironment() -1 env.id =     " + environment.getId()));
            log.debug((Object)("generateEnvironment() -1 env.parent = " + environment.getParent()));
            log.debug((Object)("generateEnvironment() -1 env.envId =  " + environment.getEnvironmentId()));
        }
        if (flowExpression.getParent() != null) {
            ExpressionPool expressionPool = Definitions.getExpressionPool(flowExpression.context());
            environment.setEnvironmentId(expressionPool.getEnvironmentId(flowExpression.getParent()));
        }
        environment.setId(flowExpressionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateEnvironment()  0 env.id =    " + environment.getId()));
            log.debug((Object)("generateEnvironment()  0 env.envId = " + environment.getEnvironmentId()));
        }
        environment.getExpressionPool().add(environment);
        flowExpression.setEnvironmentId(environment.getId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("generateEnvironment()  1 env.id =    " + environment.getId()));
            log.debug((Object)("generateEnvironment()  1 env.envId = " + environment.getEnvironmentId()));
        }
        return environment;
    }

    public synchronized void unbind() throws PoolException {
        Iterator iterator = this.variables.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof ExpressionToUnbind) {
                try {
                    ((FlowExpression)v).setApplicationContext(this.context());
                    ((ExpressionToUnbind)v).unbind();
                }
                catch (PoolException poolException) {
                    log.warn((Object)"unbind() problem. Resuming anyway.", (Throwable)((Object)poolException));
                }
                continue;
            }
            if (!(v instanceof FlowExpressionId)) continue;
            this.getExpressionPool().removeExpression((FlowExpressionId)v);
        }
    }

    public synchronized Object get(String string) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get() in " + this.getId() + " for '" + string + "'"));
        }
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new ArrayList(this.variables.keySet());
            Collections.reverse(this.cachedKeySet);
        }
        Iterator iterator = this.cachedKeySet.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).matches(string)) continue;
            return this.variables.get(object);
        }
        if (this.getId().equals(EngineEnvironmentId.ID) && (object = Definitions.getExpressionMap(this.context()).getClass(string)) != null) {
            return object;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("get() for '" + string + "'. Not found in " + this.getId()));
        }
        return null;
    }

    public Object lookup(String string) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookup() in " + this.getId() + " for '" + string + "'"));
        }
        if ((object = this.get(string)) != null) {
            return object;
        }
        if (this.getEnvironmentId() == null) {
            return this.getExpressionPool().fetchEngineEnvironment().get(string);
        }
        Environment environment = (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
        if (environment == null) {
            log.warn((Object)("lookup() didn't find an env at  " + this.getEnvironmentId()));
            return this.getExpressionPool().fetchEngineEnvironment().get(string);
        }
        return environment.lookup(string);
    }

    public Environment lookupContainingEnvironment(String string) {
        if (this.variables.containsKey(string)) {
            return this;
        }
        if (this.getId().equals(EngineEnvironmentId.ID)) {
            return null;
        }
        Environment environment = (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
        if (environment == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("lookupContainingEnvironment() did not find env  " + this.getEnvironmentId()));
            }
            return null;
        }
        return environment.lookupContainingEnvironment(string);
    }

    public synchronized void put(String string, Object object) {
        this.cachedKeySet = null;
        this.doPut(string, object);
        this.storeItself();
    }

    public synchronized void putAll(Map map) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putAll() in env  " + this.getId()));
        }
        this.cachedKeySet = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            this.doPut(string, v);
        }
        this.storeItself();
    }

    private void doPut(String string, Object object) {
        this.variables.put(string, object);
        if (log.isDebugEnabled()) {
            log.debug((Object)("put() '" + string + "' in " + this.getId()));
            if (object != null) {
                String string2 = object.toString();
                if (string2.length() > 80) {
                    string2 = string2.substring(0, 77) + "...";
                }
                log.debug((Object)("put() '" + string + "' -> >" + string2 + "<"));
            }
        }
    }

    public void reattach(FlowExpressionId flowExpressionId) {
        this.getExpressionPool().removeExpression(this.getId());
        this.setId(flowExpressionId.copy());
        this.getId().setExpressionName(EXPRESSION_NAME);
        if (!this.getId().getExpressionId().endsWith("e")) {
            this.getId().setExpressionId(this.getId().getExpressionId() + "e");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reattach() new id  " + this.getId()));
        }
        this.storeItself();
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map map) {
        this.variables = (LinkedHashMap)map;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
    }

    public static boolean ownsEnvironment(FlowExpression flowExpression) {
        FlowExpressionId flowExpressionId = flowExpression.getId().copy();
        FlowExpressionId flowExpressionId2 = flowExpression.getEnvironmentId();
        flowExpressionId.setExpressionId(flowExpressionId.getExpressionId() + "e");
        flowExpressionId.setExpressionName(EXPRESSION_NAME);
        return flowExpressionId.equals(flowExpressionId2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

