/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.Utils;
import openwfe.org.engine.workitem.Attribute;

public class FlowExpressionId
implements Attribute {
    static final long serialVersionUID = -6456469702585696792L;
    private String engineId = null;
    private String initialEngineId = null;
    private String workflowDefinitionUrl = null;
    private String workflowDefinitionName = null;
    private String workflowDefinitionRevision = null;
    private String workflowInstanceId = null;
    private String expressionName = null;
    private String expressionId = null;
    private String owfeVersion = null;

    public String getEngineId() {
        return this.engineId;
    }

    public String getInitialEngineId() {
        return this.initialEngineId;
    }

    public String getWorkflowDefinitionUrl() {
        return this.workflowDefinitionUrl;
    }

    public String getWorkflowDefinitionName() {
        return this.workflowDefinitionName;
    }

    public String getWorkflowDefinitionRevision() {
        return this.workflowDefinitionRevision;
    }

    public String getWorkflowInstanceId() {
        return this.workflowInstanceId;
    }

    public String getExpressionName() {
        return this.expressionName;
    }

    public String getExpressionId() {
        return this.expressionId;
    }

    public String getOwfeVersion() {
        return this.owfeVersion;
    }

    public void setEngineId(String string) {
        this.engineId = string;
    }

    public void setInitialEngineId(String string) {
        this.initialEngineId = string;
    }

    public void setWorkflowDefinitionUrl(String string) {
        this.workflowDefinitionUrl = string;
    }

    public void setWorkflowDefinitionName(String string) {
        this.workflowDefinitionName = string;
    }

    public void setWorkflowDefinitionRevision(String string) {
        this.workflowDefinitionRevision = string;
    }

    public void setWorkflowInstanceId(String string) {
        this.workflowInstanceId = string;
    }

    public void setExpressionName(String string) {
        this.expressionName = string;
    }

    public void setExpressionId(String string) {
        this.expressionId = string;
    }

    public void setOwfeVersion(String string) {
        this.owfeVersion = string;
    }

    public String getParentWorkflowInstanceId() {
        return FlowExpressionId.extractParentWorkflowInstanceId(this.getWorkflowInstanceId());
    }

    public static String extractParentWorkflowInstanceId(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FlowExpressionId)) {
            return false;
        }
        FlowExpressionId flowExpressionId = (FlowExpressionId)object;
        return Utils.stringEquals((String)this.engineId, (String)flowExpressionId.engineId) && Utils.stringEquals((String)this.initialEngineId, (String)flowExpressionId.initialEngineId) && Utils.stringEquals((String)this.workflowInstanceId, (String)flowExpressionId.workflowInstanceId) && Utils.stringEquals((String)this.expressionId, (String)flowExpressionId.expressionId) && Utils.stringEquals((String)this.expressionName, (String)flowExpressionId.expressionName) && Utils.stringEquals((String)this.workflowDefinitionName, (String)flowExpressionId.workflowDefinitionName) && Utils.stringEquals((String)this.workflowDefinitionRevision, (String)flowExpressionId.workflowDefinitionRevision) && Utils.stringEquals((String)this.owfeVersion, (String)flowExpressionId.owfeVersion);
    }

    public boolean isInSubFlow() {
        if (this.workflowInstanceId == null) {
            return false;
        }
        return this.workflowInstanceId.indexOf(".") > -1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() {
        FlowExpressionId flowExpressionId = new FlowExpressionId();
        flowExpressionId.engineId = Utils.copyString((String)this.engineId);
        flowExpressionId.initialEngineId = Utils.copyString((String)this.initialEngineId);
        flowExpressionId.workflowDefinitionUrl = Utils.copyString((String)this.workflowDefinitionUrl);
        flowExpressionId.workflowDefinitionName = Utils.copyString((String)this.workflowDefinitionName);
        flowExpressionId.workflowDefinitionRevision = Utils.copyString((String)this.workflowDefinitionRevision);
        flowExpressionId.workflowInstanceId = Utils.copyString((String)this.workflowInstanceId);
        flowExpressionId.expressionName = Utils.copyString((String)this.expressionName);
        flowExpressionId.expressionId = Utils.copyString((String)this.expressionId);
        flowExpressionId.owfeVersion = Utils.copyString((String)this.owfeVersion);
        return flowExpressionId;
    }

    public FlowExpressionId copy() {
        return (FlowExpressionId)this.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( fei ").append(this.owfeVersion).append(" ").append(this.engineId).append("/").append(this.initialEngineId).append(" ").append(this.workflowDefinitionUrl).append(" ").append(this.workflowDefinitionName).append(" ").append(this.workflowDefinitionRevision).append(" ").append(this.workflowInstanceId).append(" ").append(this.expressionName).append(" ").append(this.expressionId).append(" )");
        return stringBuffer.toString();
    }

    public String asStringId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getEngineId());
        stringBuffer.append("_");
        stringBuffer.append(this.getWorkflowInstanceId());
        stringBuffer.append("_");
        stringBuffer.append(this.getExpressionName());
        stringBuffer.append("_");
        stringBuffer.append(this.getExpressionId());
        return stringBuffer.toString();
    }

    public String toParseableString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.normalize(this.owfeVersion)).append("|").append(this.normalize(this.engineId)).append("|").append(this.normalize(this.initialEngineId)).append("|").append(this.normalize(this.workflowDefinitionUrl)).append("|").append(this.normalize(this.workflowDefinitionName)).append("|").append(this.normalize(this.workflowDefinitionRevision)).append("|").append(this.normalize(this.workflowInstanceId)).append("|").append(this.normalize(this.expressionName)).append("|").append(this.normalize(this.expressionId));
        return stringBuffer.toString();
    }

    private String normalize(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static FlowExpressionId fromParseableString(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (string.endsWith("|")) {
            string = string + " ";
        }
        if ((stringArray = string.split("\\|")).length != 8 && stringArray.length != 9) {
            throw new IllegalArgumentException("Cannot parse FlowExpressionId out of >" + string + "< (length is " + stringArray.length + ")");
        }
        FlowExpressionId flowExpressionId = new FlowExpressionId();
        int n = 0;
        flowExpressionId.owfeVersion = stringArray.length == 9 ? stringArray[n++].trim() : "unknown";
        flowExpressionId.engineId = stringArray[n++].trim();
        flowExpressionId.initialEngineId = stringArray[n++].trim();
        flowExpressionId.workflowDefinitionUrl = stringArray[n++].trim();
        flowExpressionId.workflowDefinitionName = stringArray[n++].trim();
        flowExpressionId.workflowDefinitionRevision = stringArray[n++].trim();
        flowExpressionId.workflowInstanceId = stringArray[n++].trim();
        flowExpressionId.expressionName = stringArray[n++].trim();
        flowExpressionId.expressionId = stringArray[n++].trim();
        return flowExpressionId;
    }
}

