/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.OneChildExpression;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.sync.SynchableExpression;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.IntegerAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import org.apache.log4j.Logger;

public class Iterator
implements Serializable {
    static final long serialVersionUID = -2532616767097005828L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$Iterator == null ? (class$openwfe$org$engine$expressions$Iterator = Iterator.class$("openwfe.org.engine.expressions.Iterator")) : class$openwfe$org$engine$expressions$Iterator).getName());
    public static final String VALUE_PREFIX = "on-";
    public static final String DEFAULT_TO_VARIABLE = "__iteration_value__";
    public static final String VALUE_SEPARATOR = "value-separator";
    public static final String DEFAULT_VALUE_SEPARATOR = ", *";
    public static final String F_ITERATION_POSITION = "__ip__";
    private int iterationPosition = -1;
    private List iterationList = null;
    private FlowExpressionId templateId = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$Iterator;

    public Iterator() {
    }

    public Iterator(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.prepareIterationList(flowExpression, inFlowWorkItem);
    }

    public int getIterationPosition() {
        return this.iterationPosition;
    }

    public List getIterationList() {
        return this.iterationList;
    }

    public FlowExpressionId getTemplateId() {
        return this.templateId;
    }

    public void setIterationPosition(int n) {
        this.iterationPosition = n;
    }

    public void setIterationList(List list) {
        this.iterationList = list;
    }

    public void setTemplateId(FlowExpressionId flowExpressionId) {
        this.templateId = flowExpressionId;
    }

    public Object currentIterationValue() {
        try {
            return this.iterationList.get(this.iterationPosition);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized boolean hasNext() {
        boolean bl;
        if (this.iterationList == null || this.iterationList.size() < 1) {
            return false;
        }
        boolean bl2 = bl = this.iterationPosition < this.iterationList.size() - 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hasNext() ? " + bl));
        }
        return bl;
    }

    public synchronized void next(OneChildExpression oneChildExpression, InFlowWorkItem inFlowWorkItem) throws OpenWfeException {
        if (this.templateId == null) {
            this.templateId = oneChildExpression.getChildExpressionId();
        }
        oneChildExpression.tag(inFlowWorkItem);
        ++this.iterationPosition;
        if (log.isDebugEnabled()) {
            log.debug((Object)"next() tagged workitem");
            log.debug((Object)("next() iteratingExpression is " + oneChildExpression.getId()));
            log.debug((Object)("next() iterationPosition : " + this.iterationPosition));
            log.debug((Object)("next() currentIterationValue >" + this.currentIterationValue() + "<"));
        }
        try {
            Map map = ValueUtils.determineAndSetTarget("to-", oneChildExpression, inFlowWorkItem, this.currentIterationValue());
            Launcher launcher = Definitions.getLauncher(oneChildExpression.context());
            inFlowWorkItem.getAttributes().put(F_ITERATION_POSITION, (Attribute)new IntegerAttribute(this.iterationPosition));
            FlowExpressionId flowExpressionId = launcher.launchSub(inFlowWorkItem, oneChildExpression.getId(), oneChildExpression.getChildExpressionId(), map, true);
            this.addChild(oneChildExpression, flowExpressionId);
        }
        catch (OpenWfeException openWfeException) {
            throw new ApplyException("Failed to apply next scope", openWfeException);
        }
        if (!this.hasNext()) {
            oneChildExpression.getExpressionPool().removeExpression(this.templateId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("next() removed template " + this.templateId));
            }
        }
    }

    protected void addChild(FlowExpression flowExpression, FlowExpressionId flowExpressionId) {
        if (flowExpression == null) {
            log.info((Object)"addChildToParent() parent is null");
        }
        if (!(flowExpression instanceof SynchableExpression)) {
            return;
        }
        ((SynchableExpression)flowExpression).getSyncExpression().addChild(flowExpressionId);
        flowExpression.storeItself();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addChildToParent() added " + flowExpressionId + " to " + flowExpression.getId()));
        }
    }

    protected void prepareIterationList(FlowExpression flowExpression, InFlowWorkItem inFlowWorkItem) throws ApplyException {
        Object object = null;
        try {
            object = ValueUtils.determineValue(VALUE_PREFIX, flowExpression, inFlowWorkItem);
        }
        catch (ValueException valueException) {
            throw new ApplyException("Failed to determine value to iterate on", (Throwable)((Object)valueException));
        }
        String string = (String)flowExpression.getAttributes().get(VALUE_SEPARATOR);
        if (string == null) {
            string = DEFAULT_VALUE_SEPARATOR;
        }
        if (object == null) {
            this.iterationList = null;
            log.debug((Object)"prepareIterationList() nothing to iterate on...");
        } else if (object instanceof List) {
            this.iterationList = (List)object;
        } else if (object instanceof String || object instanceof StringAttribute) {
            String[] stringArray = object.toString().split(string);
            this.iterationList = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.iterationList.add(stringArray[i].trim());
            }
        } else if (object instanceof MapAttribute) {
            MapAttribute mapAttribute = (MapAttribute)object;
            this.iterationList = new ArrayList(mapAttribute.values().size());
            java.util.Iterator iterator = mapAttribute.values().iterator();
            while (iterator.hasNext()) {
                this.iterationList.add(iterator.next().toString());
            }
        } else if (object instanceof ListAttribute) {
            ListAttribute listAttribute = (ListAttribute)object;
            this.iterationList = new ArrayList(listAttribute.size());
            java.util.Iterator iterator = listAttribute.iterator();
            while (iterator.hasNext()) {
                this.iterationList.add(iterator.next().toString());
            }
        } else {
            throw new ApplyException("value of class '" + object.getClass().getName() + "' is not suitable for iteration");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

