/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;
import openwfe.org.engine.expressions.FilterDefinitionExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.TimeoutUtils;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.expressions.state.FrozenState;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.BooleanAttribute;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class ParticipantExpression
extends ZeroChildExpression
implements ExpressionWithTimeOut {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$ParticipantExpression == null ? (class$openwfe$org$engine$expressions$ParticipantExpression = ParticipantExpression.class$("openwfe.org.engine.expressions.ParticipantExpression")) : class$openwfe$org$engine$expressions$ParticipantExpression).getName());
    public static final String A_REF = "ref";
    public static final String A_FILTER = "filter";
    private static final String HISTORY_TEXT = "ok";
    public static final String A_DESCRIPTION = "description";
    public static final String DESCRIPTION_FIELD_NAME = "__description__";
    public static final String A_DEFAULT_REF = "default-ref";
    public static final String A_FIELD_REF = "field-ref";
    public static final String A_VARIABLE_REF = "variable-ref";
    public static final String DEFAULT_FIELD_REF = "__next_participant__";
    public static final String A_ELSE_REF = "else-ref";
    public static final String A_FORGET = "forget";
    public static final String F_FORGOTTEN_FIELD = "__forgotten__";
    private Filter filter = null;
    private InFlowWorkItem appliedWorkitem = null;
    protected String description = null;
    protected Attribute oldDescriptionValue = null;
    protected String dynaParticipantName = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$ParticipantExpression;

    public Filter getFilter() {
        return this.filter;
    }

    public InFlowWorkItem getAppliedWorkitem() {
        return this.appliedWorkitem;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setAppliedWorkitem(InFlowWorkItem inFlowWorkItem) {
        this.appliedWorkitem = inFlowWorkItem;
    }

    public void setParent(FlowExpressionId flowExpressionId) {
        super.setParent(flowExpressionId);
    }

    protected String getParticipantName(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.dynaParticipantName != null) {
            return this.dynaParticipantName;
        }
        String string = this.lookupAttribute(A_DEFAULT_REF, inFlowWorkItem);
        String string2 = this.lookupAttribute(A_REF, inFlowWorkItem);
        String string3 = this.lookupAttribute(A_FIELD_REF, inFlowWorkItem);
        String string4 = this.lookupAttribute(A_VARIABLE_REF, inFlowWorkItem);
        if (string3 == null && string4 == null) {
            string3 = DEFAULT_FIELD_REF;
        }
        Object object = null;
        if (string2 != null) {
            object = string2;
        } else if (string3 != null && this.appliedWorkitem != null) {
            object = this.appliedWorkitem.getAttribute(string3);
        } else if (string4 != null) {
            object = this.lookupVariable(string4);
        }
        this.dynaParticipantName = object == null ? string : object.toString();
        if (this.dynaParticipantName == null) {
            this.dynaParticipantName = this.lookupAttribute(A_REF, inFlowWorkItem);
        }
        if (this.dynaParticipantName == null) {
            throw new ApplyException("Could not determine dynamically or statically the target participant. Is 'field-ref', 'variable-ref' or 'ref' set in the flow definition ?");
        }
        return this.dynaParticipantName;
    }

    protected Participant lookupParticipant(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        String string = this.getParticipantName(inFlowWorkItem);
        ParticipantMap participantMap = Definitions.getParticipantMap(this.context());
        if (participantMap == null) {
            throw new ApplyException("Cannot find participantMap  service. Cannot retrieve any participant.");
        }
        Participant participant = participantMap.get(string);
        if (participant == null) {
            throw new ApplyException("Participant '" + string + "' not found");
        }
        inFlowWorkItem.setParticipantName(string);
        return participant;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        Object object;
        boolean bl;
        this.touchApplyTime();
        ValueUtils.cleanResult(inFlowWorkItem);
        String string = this.lookupAttribute(A_FORGET, inFlowWorkItem);
        boolean bl2 = bl = string != null && string.trim().equals("true");
        if (this.getAttributes().keySet().contains(A_FILTER)) {
            object = this.lookupAttribute(A_FILTER, inFlowWorkItem);
            FilterDefinitionExpression filterDefinitionExpression = (FilterDefinitionExpression)this.lookupVariable((String)object);
            if (filterDefinitionExpression != null) {
                filterDefinitionExpression.setApplicationContext(this.context());
                this.filter = filterDefinitionExpression.buildFilter(inFlowWorkItem);
            } else {
                log.warn((Object)("apply() did not find filter '" + (String)object + "'"));
            }
        }
        this.description = this.lookupAttribute(A_DESCRIPTION, inFlowWorkItem);
        this.tag(inFlowWorkItem);
        this.appliedWorkitem = (InFlowWorkItem)inFlowWorkItem.clone();
        if (this.description != null) {
            this.oldDescriptionValue = inFlowWorkItem.getAttribute(DESCRIPTION_FIELD_NAME);
            inFlowWorkItem.getAttributes().puts(DESCRIPTION_FIELD_NAME, this.description);
        }
        object = inFlowWorkItem;
        if (this.filter != null) {
            object = this.filter.constrain(inFlowWorkItem);
        }
        if (bl) {
            ((WorkItem)object).getAttributes().puts(F_FORGOTTEN_FIELD, "true");
        }
        this.storeItself();
        this.regularDispatch((InFlowWorkItem)object);
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"apply() forget is set to 'true', resuming flow");
            }
            try {
                inFlowWorkItem.getAttributes().remove(F_FORGOTTEN_FIELD);
                this.reply(inFlowWorkItem);
            }
            catch (ReplyException replyException) {
                throw new ApplyException("participant with forget set to 'true' : failed to immediately reply to parent");
            }
        }
    }

    protected void dispatch(Participant participant, String string, InFlowWorkItem inFlowWorkItem) throws ApplyException, DispatchingException {
        inFlowWorkItem.setParticipantName(string);
        participant.dispatch(this.context(), inFlowWorkItem);
    }

    protected void regularDispatch(InFlowWorkItem inFlowWorkItem) {
        String string = null;
        try {
            Participant participant = this.lookupParticipant(inFlowWorkItem);
            string = this.getParticipantName(inFlowWorkItem);
            this.dispatch(participant, string, inFlowWorkItem);
            this.historyLog(inFlowWorkItem, "+DIS", string, this.getClass().getName());
            return;
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("regularDispatch() failed to dispatch to '" + string + "'"), throwable);
            }
            log.warn((Object)("regularDispatch() failed to dispatch to '" + string + "'\n" + throwable));
            this.historyLog(inFlowWorkItem, "-dsf", string, "" + throwable);
            this.elseDispatch(inFlowWorkItem);
            return;
        }
    }

    protected void elseDispatch(InFlowWorkItem inFlowWorkItem) {
        Object object;
        String string = this.lookupAttribute(A_ELSE_REF, inFlowWorkItem);
        if (string != null) {
            object = string.split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                String string2 = object[i].trim();
                if (string2.equals("")) continue;
                Participant participant = this.getParticipantMap().get(string2);
                if (participant == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("elseDispatch() unknown participant '" + string2 + "', continuing."));
                    continue;
                }
                try {
                    this.dispatch(participant, string2, inFlowWorkItem);
                    this.historyLog(inFlowWorkItem, "+DIS", "else-ref:" + string2, this.getClass().getName());
                }
                catch (Throwable throwable) {
                    log.warn((Object)("elseDispatch() failed to dispatch to '" + string2 + "' " + throwable + ", continuing..."));
                    this.historyLog(inFlowWorkItem, "-dsf", "else-ref:" + string2, "" + throwable);
                }
                return;
            }
        }
        log.warn((Object)("elseDispatch() freezing self : " + this.getId()));
        object = new FrozenState();
        ((FrozenState)object).setAppliedItem(inFlowWorkItem);
        this.setState((ExpressionState)object);
        this.storeItself();
    }

    public void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (this.filter != null) {
            inFlowWorkItem = this.filter.enforce(this.appliedWorkitem, inFlowWorkItem);
        }
        this.addHistoryItem(inFlowWorkItem);
        if (this.description != null) {
            if (this.oldDescriptionValue != null) {
                inFlowWorkItem.getAttributes().put(DESCRIPTION_FIELD_NAME, this.oldDescriptionValue);
            } else {
                inFlowWorkItem.getAttributes().remove(DESCRIPTION_FIELD_NAME);
            }
        }
        inFlowWorkItem.getAttributes().remove("__timed_out__");
        super.reply(inFlowWorkItem);
    }

    protected void addHistoryItem(InFlowWorkItem inFlowWorkItem) {
        if (inFlowWorkItem.getHistory() == null) {
            inFlowWorkItem.setHistory(new ArrayList(1));
        }
        HistoryItem historyItem = new HistoryItem(this.getId());
        try {
            historyItem.setAuthor("participant::" + this.getParticipantName(inFlowWorkItem));
        }
        catch (ApplyException applyException) {
            historyItem.setAuthor("participant::unknown");
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            historyItem.setHost(inetAddress.getHostName() + " / " + inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            historyItem.setHost("" + unknownHostException);
        }
        historyItem.setText(HISTORY_TEXT);
        inFlowWorkItem.getHistory().add(historyItem);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancel() --> " + this.getId()));
        }
        if (this.appliedWorkitem == null) {
            return null;
        }
        Participant participant = this.lookupParticipant(this.appliedWorkitem);
        CancelItem cancelItem = new CancelItem(this.getId(), this.getParticipantName(this.appliedWorkitem));
        try {
            participant.dispatch(this.context(), cancelItem);
            if (log.isDebugEnabled()) {
                log.debug((Object)"cancel() cancelItem dispatched");
            }
        }
        catch (DispatchingException dispatchingException) {
            throw new ApplyException("Failed to notify participant '" + this.getParticipantName(this.appliedWorkitem) + "' with cancel item", (Throwable)((Object)dispatchingException));
        }
        super.cancel();
        return this.appliedWorkitem;
    }

    public boolean isTimeOutActivated() {
        if (this.getApplyTime() == null || this.getState() instanceof FrozenState) {
            return false;
        }
        return this.determineTimeOut() != -1L;
    }

    public void timeOutReply() throws ReplyException {
        String string = "unknown";
        try {
            string = this.getParticipantName(this.appliedWorkitem);
        }
        catch (ApplyException applyException) {
            // empty catch block
        }
        this.appliedWorkitem.addHistoryItem(string, "participant timed out");
        this.historyLog(this.appliedWorkitem, "+TOU", string, "");
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() setting '__timed_out__' to 'true'");
        }
        this.appliedWorkitem.getAttributes().put("__timed_out__", (Attribute)new BooleanAttribute(true));
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() cancelling self...");
        }
        try {
            this.cancel();
        }
        catch (ApplyException applyException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to send cancel message", (Throwable)((Object)applyException));
            }
            throw new ReplyException("Failed to send cancel message", (Throwable)((Object)applyException));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"timeOutReply() resuming flow");
        }
        super.reply(this.appliedWorkitem);
    }

    public Long determineTimeOut() {
        Long l = TimeoutUtils.determineTimeout(this, this.appliedWorkitem);
        if (l == null) {
            Participant participant = null;
            try {
                participant = this.lookupParticipant(this.appliedWorkitem);
            }
            catch (ApplyException applyException) {
                log.info((Object)"determineTimeOut() Couldn't determine participant for timeout computation", (Throwable)((Object)applyException));
            }
            if (participant != null) {
                String string = null;
                if (participant.getParams() != null) {
                    string = (String)participant.getParams().get("timeout");
                }
                l = TimeoutUtils.determineTimeout(string);
            }
        }
        if (l == null) {
            l = this.getExpressionPool().getExpressionTimeOut();
        }
        if (l == null) {
            l = new Long(-1L);
        }
        if (log.isDebugEnabled()) {
            if (l > -1L) {
                log.debug((Object)("determineTimeOut() time out for participant is set to " + l + " (" + Time.toTimeString((Long)l, (boolean)false) + ")."));
            } else {
                log.debug((Object)"determineTimeOut() no time out for participant.");
            }
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

