/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.AbstractCompositeFlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;

public class PrintExpression
extends AbstractCompositeFlowExpression
implements WithChildren {
    public static final String A_TEXT = "text";
    private int childIndex = -1;

    public int getChildIndex() {
        return this.childIndex;
    }

    public void setChildIndex(int n) {
        this.childIndex = n;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        if (this.getChildren().size() < 1) {
            String string = this.lookupAttribute(A_TEXT, inFlowWorkItem);
            if (string == null) {
                string = this.lookupAttribute("__value__", inFlowWorkItem);
            }
            if (string != null) {
                if (string.trim().length() < 1) {
                    System.out.println();
                } else {
                    System.out.println(string);
                }
            }
            this.applyToParent(inFlowWorkItem);
            return;
        }
        this.childIndex = 0;
        this.applyNextChild(inFlowWorkItem);
    }

    public synchronized void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        String string = inFlowWorkItem.getAttributes().sget("__result__");
        if (string != null && string.startsWith("<?xml")) {
            int n = string.indexOf("\n");
            if (n > -1) {
                string = string.substring(n + 1);
            }
            string = string.trim();
        }
        System.out.print(string);
        if (this.childIndex >= this.getChildren().size()) {
            System.out.println();
            this.replyToParent(inFlowWorkItem);
            return;
        }
        try {
            this.applyNextChild(inFlowWorkItem);
        }
        catch (ApplyException applyException) {
            throw new ReplyException("Failed to apply next child", (Throwable)((Object)applyException));
        }
    }

    private void applyNextChild(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        Object e = this.getChildren().get(this.childIndex);
        ++this.childIndex;
        this.storeItself();
        if (e instanceof String) {
            String string = this.substituteText((String)e, inFlowWorkItem);
            this.tag(inFlowWorkItem);
            ValueUtils.setResult(inFlowWorkItem, new StringAttribute(string));
            try {
                this.reply(inFlowWorkItem);
            }
            catch (ReplyException replyException) {
                throw new ApplyException("failed to go beyond next child", (Throwable)((Object)replyException));
            }
            return;
        }
        this.getExpressionPool().apply((FlowExpressionId)e, inFlowWorkItem);
    }
}

