/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Scheduler;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class SleepExpression
extends ZeroChildExpression
implements Schedulable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$SleepExpression == null ? (class$openwfe$org$engine$expressions$SleepExpression = SleepExpression.class$("openwfe.org.engine.expressions.SleepExpression")) : class$openwfe$org$engine$expressions$SleepExpression).getName());
    public static final String FOR = "for";
    public static final String UNTIL = "until";
    private InFlowWorkItem sleepingWorkitem = null;
    private long awakeningTime = -1L;
    private Long atId = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$SleepExpression;

    public InFlowWorkItem getSleepingWorkitem() {
        return this.sleepingWorkitem;
    }

    public long getAwakeningTime() {
        return this.awakeningTime;
    }

    public void setSleepingWorkitem(InFlowWorkItem inFlowWorkItem) {
        this.sleepingWorkitem = inFlowWorkItem;
    }

    public void setAwakeningTime(long l) {
        this.awakeningTime = l;
    }

    public Long getAtId() {
        return this.atId;
    }

    public void trigger(Object[] objectArray) {
        if (this.sleepingWorkitem == null) {
            return;
        }
        try {
            this.applyToParent(this.sleepingWorkitem);
        }
        catch (ApplyException applyException) {
            log.warn((Object)"trigger() couldn't reply to parent expression !!!", (Throwable)((Object)applyException));
        }
    }

    public Long reschedule(Scheduler scheduler) {
        return this.getExpressionPool().scheduleAt(this.awakeningTime, this.getId());
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        String string = this.lookupAttribute(FOR, inFlowWorkItem);
        String string2 = this.lookupAttribute(UNTIL, inFlowWorkItem);
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() sFor   >" + string + "<"));
            log.debug((Object)("apply() sUntil >" + string2 + "<"));
        }
        if (string != null) {
            long l = Time.parseTimeString((String)string);
            this.awakeningTime = System.currentTimeMillis() + l;
        } else {
            if (string2 == null) {
                this.throwSleepException(inFlowWorkItem, "no 'for' or 'until' found, no sleep.");
                return;
            }
            try {
                this.awakeningTime = Time.parseDate((String)string2).getTime();
                if (this.awakeningTime < System.currentTimeMillis()) {
                    log.info((Object)("apply() awakeningTime (" + Time.toIsoDate((long)this.awakeningTime) + ") before current time. No sleep."));
                    this.applyToParent(inFlowWorkItem);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.throwSleepException(inFlowWorkItem, "Couldn't parse '" + string2 + "' : " + throwable);
                return;
            }
        }
        this.sleepingWorkitem = inFlowWorkItem;
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() entered sleep 'til " + Time.toIsoDate((long)this.awakeningTime) + " ." + this.awakeningTime % 1000L + "      " + this.getId()));
        }
        this.atId = this.reschedule(null);
        this.storeItself();
    }

    protected void throwSleepException(InFlowWorkItem inFlowWorkItem, String string) throws ApplyException {
        inFlowWorkItem.addHistoryItem(this.getId(), this.getClass().getName(), string);
        this.historyLog(inFlowWorkItem, "-err", null, string);
        log.debug((Object)string);
        this.applyToParent(inFlowWorkItem);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        if (this.atId != null) {
            this.getExpressionPool().getScheduler().unscheduleAt(this.atId);
        }
        return super.cancel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

