/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.Utils;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ChildrenTracker;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.launch.LaunchException;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import org.apache.log4j.Logger;

public class SubProcessRefExpression
extends ZeroChildExpression
implements WithChildren {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$SubProcessRefExpression == null ? (class$openwfe$org$engine$expressions$SubProcessRefExpression = SubProcessRefExpression.class$("openwfe.org.engine.expressions.SubProcessRefExpression")) : class$openwfe$org$engine$expressions$SubProcessRefExpression).getName());
    public static final String A_VARIABLE_REF = "variable-ref";
    public static final String A_FIELD_REF = "field-ref";
    public static final String A_REF = "ref";
    public static final String A_FORGET = "forget";
    public static final String A_FIELDS = "fields";
    public static final String V_CPARAMS = "__cparams__";
    public static final String ENGINE_SEPARATOR = "::";
    private FlowExpressionId subId = null;
    private boolean forgetting = false;
    private Map launchVariables = null;
    private ChildrenTracker tracker = null;
    private FlowExpressionId launchedId = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$SubProcessRefExpression;

    public FlowExpressionId getSubId() {
        return this.subId;
    }

    public void setSubId(FlowExpressionId flowExpressionId) {
        this.subId = flowExpressionId;
    }

    public boolean isForgetting() {
        return this.forgetting;
    }

    public void setForgetting(boolean bl) {
        this.forgetting = bl;
    }

    public Map getLaunchVariables() {
        return this.launchVariables;
    }

    public void setLaunchVariables(Map map) {
        this.launchVariables = map;
    }

    public ChildrenTracker getTracker() {
        return this.tracker;
    }

    public void setTracker(ChildrenTracker childrenTracker) {
        this.tracker = childrenTracker;
    }

    public FlowExpressionId getLaunchedId() {
        return this.launchedId;
    }

    public void setLaunchedId(FlowExpressionId flowExpressionId) {
        this.launchedId = flowExpressionId;
    }

    public void apply(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        this.forgetting = this.shouldForget(inFlowWorkItem);
        String string = this.determineReference(inFlowWorkItem);
        string = this.checkIfLocalEngine(string);
        if (log.isDebugEnabled()) {
            log.debug((Object)("apply() ref >" + string + "< for  " + this.getId()));
        }
        if (this.isUrl(string)) {
            this.outerLaunch(inFlowWorkItem, string);
            return;
        }
        this.innerLaunch(inFlowWorkItem, string);
    }

    public synchronized void reply(InFlowWorkItem inFlowWorkItem) throws ReplyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("reply() from " + inFlowWorkItem.getLastExpressionId()));
        }
        if (this.tracker == null) {
            log.debug((Object)"reply() no tracker : replying to parent.");
            this.replyToParent(inFlowWorkItem);
            return;
        }
        this.tracker.reply(inFlowWorkItem);
        if (this.tracker.hasNext()) {
            log.debug((Object)"reply() applying next child");
            this.tracker.applyNext(this);
            return;
        }
        this.launchVariables.put(V_CPARAMS, this.tracker.getRemainingContent());
        this.launchVariables.putAll(this.tracker.getResults());
        try {
            this.doLaunch(this.tracker.getWorkitem());
        }
        catch (ApplyException applyException) {
            throw new ReplyException("'after children evaluation' sublaunch failure", (Throwable)((Object)applyException));
        }
        this.tracker = null;
    }

    public InFlowWorkItem cancel() throws ApplyException {
        if (this.launchedId != null) {
            this.getExpressionPool().childCancel(this.launchedId);
        }
        return super.cancel();
    }

    protected void outerLaunch(InFlowWorkItem inFlowWorkItem, String string) throws ApplyException {
        InFlowWorkItem inFlowWorkItem2 = this.prepareSubWorkitem(inFlowWorkItem);
        FlowExpressionId flowExpressionId = this.getId();
        if (this.isForgetting()) {
            flowExpressionId = null;
        } else {
            this.storeItself();
        }
        this.historyLog(inFlowWorkItem, "+STA", null, "launching ref=\"" + string + "\"");
        try {
            this.getLauncher().launch(inFlowWorkItem2, flowExpressionId, string, this.areLaunchesAsync());
        }
        catch (LaunchException launchException) {
            throw new ApplyException("outer launch failure " + string, (Throwable)((Object)launchException));
        }
        if (this.isForgetting()) {
            this.applyToParent(inFlowWorkItem);
        }
    }

    public void innerLaunch(InFlowWorkItem inFlowWorkItem, String string) throws ApplyException {
        String string2;
        Object object;
        Object object2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() ref is \"" + string + "\""));
        }
        if ((object2 = this.lookupVariable(string)) == null) {
            throw new ApplyException("ref '" + string + "' points to nothing.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() oValue.class " + object2.getClass().getName()));
        }
        if (!(object2 instanceof FlowExpressionId) && !(object2 instanceof RawExpression)) {
            log.warn((Object)("innerLaunch() oValue class : " + object2.getClass().getName()));
            throw new ApplyException("ref '" + string + "' doesn't point to a subprocess.");
        }
        RawExpression rawExpression = null;
        if (object2 instanceof RawExpression) {
            rawExpression = (RawExpression)object2;
            rawExpression = (RawExpression)rawExpression.clone();
            rawExpression.getId().setWorkflowInstanceId(RawExpression.determineNewWorkflowInstanceId());
            try {
                this.getExpressionPool().add(rawExpression);
            }
            catch (PoolException poolException) {
                throw new ApplyException("Failed to store new template into expression pool", (Throwable)((Object)poolException));
            }
            this.subId = rawExpression.getId();
        } else {
            this.subId = (FlowExpressionId)object2;
            object = this.getExpressionPool().fetch(this.subId);
            if (object == null) {
                throw new ApplyException("innerLaunch() subprocess '" + string + "' points at  " + this.subId + " but it's gone from the expool");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("innerLaunch()  " + this.subId + "  is of class " + object.getClass().getName()));
            }
            rawExpression = (RawExpression)object;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() inner subprocess at " + this.subId));
        }
        this.launchVariables = new HashMap();
        object = this.getAttributes().keySet().iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            this.launchVariables.put(string2, this.lookupAttribute(string2, inFlowWorkItem));
        }
        string2 = rawExpression.lookupAttribute("map-children", inFlowWorkItem);
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() map-children=\"" + string2 + "\""));
        }
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = string2.split(",\\s*");
        }
        if (stringArray == null || stringArray.length < 1) {
            log.debug((Object)"innerLaunch() no children to map, launching directly");
            this.doLaunch(inFlowWorkItem);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("innerLaunch() childrenToMap.length : " + stringArray.length));
        }
        String string3 = (String)this.launchVariables.get("__content__");
        this.tracker = new ChildrenTracker();
        this.tracker.init(string3, stringArray, inFlowWorkItem);
        try {
            this.tracker.applyNext(this);
        }
        catch (ReplyException replyException) {
            throw new ApplyException("failed to begin with children evaluation", (Throwable)((Object)replyException));
        }
    }

    protected void doLaunch(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        String string;
        FlowExpressionId flowExpressionId = this.getId();
        if (this.isForgetting()) {
            flowExpressionId = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doLaunch() this.id is      " + this.getId()));
            log.debug((Object)("doLaunch() this.parent is  " + this.getParent()));
            log.debug((Object)("doLaunch() parentId is     " + flowExpressionId));
        }
        if ((string = (String)this.launchVariables.get("__content__")) != null && !this.launchVariables.keySet().contains(V_CPARAMS)) {
            this.launchVariables.put(V_CPARAMS, string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("doLaunch() cparams from content : " + string));
            }
        }
        try {
            this.launchedId = this.getLauncher().launchSub((InFlowWorkItem)inFlowWorkItem.clone(), flowExpressionId, this.subId, this.launchVariables, this.areLaunchesAsync());
        }
        catch (LaunchException launchException) {
            throw new ApplyException("Failed to launch inner subprocess  " + this.subId, (Throwable)((Object)launchException));
        }
        if (this.isForgetting()) {
            this.applyToParent(inFlowWorkItem);
        } else {
            this.storeItself();
        }
    }

    private boolean isUrl(String string) throws ApplyException {
        if (string == null || string.length() < 1) {
            throw new ApplyException("Cannot launch null or \"\" flow url");
        }
        if (Utils.isUrl((String)string)) {
            return true;
        }
        int n = string.indexOf(ENGINE_SEPARATOR);
        if (n > -1) {
            if (n + 2 == string.length()) {
                return false;
            }
            return Utils.isUrl((String)string.substring(n + 2));
        }
        return false;
    }

    public void setAttributes(Map map) {
        super.setAttributes(map);
    }

    protected boolean areLaunchesAsync() {
        return this.context().getBoolean("asyncLaunch", true);
    }

    private String checkIfLocalEngine(String string) {
        if (string.indexOf(ENGINE_SEPARATOR) < 0) {
            return string;
        }
        String string2 = this.context().getApplicationName();
        if (string2 == null) {
            log.warn((Object)"application param 'engineId' is missing, cannot determine engineId");
            return string;
        }
        String[] stringArray = string.split(ENGINE_SEPARATOR);
        if (stringArray[0].equals(string2)) {
            return stringArray[1];
        }
        return string;
    }

    protected String determineReference(InFlowWorkItem inFlowWorkItem) throws ApplyException {
        String string = this.lookupAttribute(A_VARIABLE_REF, inFlowWorkItem);
        if (string != null) {
            String string2 = (String)this.lookupVariable(string);
            if (string2 == null) {
                throw new ApplyException("no variable set under name '" + string + "'");
            }
            return string2;
        }
        String string3 = this.lookupAttribute(A_FIELD_REF, inFlowWorkItem);
        if (string3 != null) {
            Attribute attribute = inFlowWorkItem.getAttributes().get(string3);
            String string4 = null;
            if (attribute != null) {
                string4 = attribute.toString();
            }
            if (string4 == null) {
                throw new ApplyException("workitem holds no field named '" + string3 + "'");
            }
            return string4;
        }
        String string5 = this.lookupAttribute(A_REF, inFlowWorkItem);
        if (string5 == null) {
            throw new ApplyException("No 'variable-ref', 'field-ref' or 'ref' attribute in 'subprocess' expression");
        }
        return string5;
    }

    private void addFieldsFromRegex(String string, InFlowWorkItem inFlowWorkItem, InFlowWorkItem inFlowWorkItem2) {
        Iterator iterator = inFlowWorkItem.getAttributes().keyNamesMatching(string).iterator();
        while (iterator.hasNext()) {
            String string2 = ((String)iterator.next()).trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("prepareFields() adding field '" + string2 + "'"));
            }
            Attribute attribute = inFlowWorkItem.getAttribute(string2);
            inFlowWorkItem2.getAttributes().put(new StringAttribute(string2), attribute);
        }
    }

    private void addFieldWithValue(String string, InFlowWorkItem inFlowWorkItem) {
        String[] stringArray = string.split(" *= *");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("addFieldWithValue() newWi['" + string2 + "'] = '" + string3 + "'"));
        }
        inFlowWorkItem.getAttributes().put(new StringAttribute(string2), (Attribute)new StringAttribute(string3));
    }

    private void addFieldAlias(String string, InFlowWorkItem inFlowWorkItem, InFlowWorkItem inFlowWorkItem2) {
        String[] stringArray = string.split(" *as *");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        Attribute attribute = inFlowWorkItem.getAttribute(string3);
        if (attribute != null) {
            inFlowWorkItem2.getAttributes().put(new StringAttribute(string2), attribute);
        }
    }

    private InFlowWorkItem prepareSubWorkitem(InFlowWorkItem inFlowWorkItem) {
        String string = this.lookupAttribute(A_FIELDS, inFlowWorkItem);
        InFlowWorkItem inFlowWorkItem2 = (InFlowWorkItem)inFlowWorkItem.clone();
        if (string == null) {
            return inFlowWorkItem2;
        }
        inFlowWorkItem2.setAttributes(new StringMapAttribute());
        String[] stringArray = string.split(", *");
        for (int i = 0; i < stringArray.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("prepareFields() considering '" + stringArray[i] + "'..."));
            }
            if (stringArray[i].indexOf("=") > -1) {
                this.addFieldWithValue(stringArray[i], inFlowWorkItem2);
                continue;
            }
            if (stringArray[i].indexOf(" as ") > -1) {
                this.addFieldAlias(stringArray[i], inFlowWorkItem, inFlowWorkItem2);
                continue;
            }
            this.addFieldsFromRegex(stringArray[i], inFlowWorkItem, inFlowWorkItem2);
        }
        return inFlowWorkItem2;
    }

    private boolean shouldForget(InFlowWorkItem inFlowWorkItem) {
        if (Utils.toBoolean((Object)inFlowWorkItem.getAttribute(A_FORGET))) {
            return true;
        }
        if (Utils.toBoolean((Object)this.lookupVariable(A_FORGET))) {
            return true;
        }
        return Utils.toBoolean((Object)this.lookupAttribute(A_FORGET, inFlowWorkItem));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

